# Copilot Instructions for AI Coding Agents

## Project Overview
This is a Laravel-based travel accounting system. The codebase follows standard Laravel conventions but includes custom models, controllers, and workflows tailored for travel industry accounting.

## Architecture & Major Components
- **app/Models/**: Contains Eloquent models for domain entities (e.g., `Invoice`, `HotelBooking`, `Client`, `Company`, `Carrier`).
- **app/Http/Controllers/**: Handles HTTP requests, business logic, and orchestrates model interactions.
- **database/migrations/**: Defines schema changes. Migration filenames use a date-based prefix for ordering.
- **resources/views/**: Blade templates for UI rendering.
- **routes/**: Route definitions split by context (`web.php`, `api.php`, etc.).
- **config/**: Laravel and custom configuration files (e.g., `permission.php`, `fortify.php`).

## Developer Workflows
- **Build/Serve**: Use `php artisan serve` for local development. For Docker, use `docker-compose up`.
- **Database**: SQLite is used for local development (`database/database.sqlite`). Migrate with `php artisan migrate`.
- **Testing**: Run tests with `php artisan test` or `vendor/bin/phpunit`. Feature and unit tests are in `tests/Feature/` and `tests/Unit/`.
- **Debugging**: Use Laravel's built-in logging (`storage/logs/`) and exception handling. Debugbar or Xdebug may be integrated but check config files for specifics.

## Project-Specific Patterns & Conventions
- **Model Naming**: Singular, PascalCase (e.g., `HotelBooking`).
- **Migration Filenames**: Prefixed with date and time for ordering (e.g., `2025_10_06_054105_create_hotels_table.php`).
- **Custom Configs**: See `config/permission.php` and `config/fortify.php` for custom auth and permission logic.
- **Service Providers**: Custom providers in `app/Providers/` extend Laravel functionality (e.g., `FortifyServiceProvider`).
- **Requests**: Form request validation is handled in `app/Http/Requests/`.

## Integration Points & External Dependencies
- **Composer**: PHP dependencies managed via `composer.json`.
- **Node/Vite**: Frontend assets built with Vite (`vite.config.ts`, `package.json`). Use `npm run dev` for asset compilation.
- **Docker**: Containerization via `Dockerfile` and `docker-compose.yml`.
- **Third-Party Packages**: Check `composer.json` for packages like `spatie/laravel-permission`, `laravel/fortify`, and others.

## Examples of Key Patterns
- **Eloquent Relationships**: Models define relationships using Laravel conventions (e.g., `hasMany`, `belongsTo`).
- **Route Organization**: API routes in `routes/api.php`, web routes in `routes/web.php`.
- **Custom Middleware**: Placed in `app/Http/Middleware/` for request filtering and logic.

## Quick Reference
- **Start Dev Server**: `php artisan serve`
- **Run Migrations**: `php artisan migrate`
- **Run Tests**: `php artisan test`
- **Build Frontend**: `npm run dev`
- **Docker Up**: `docker-compose up`

---
For unclear or missing conventions, ask the user for clarification or examples from their workflow.
