<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Inertia\Inertia;
use App\Models\Carrier;
use App\Models\BankAccount;

class CarrierController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return Inertia::render("App Settings/Carrier/Index", [
            "carriers" => Carrier::with(['bankAccount'])->get()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render("App Settings/Carrier/Create", [
            "bankAccounts" => BankAccount::all()
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'                  => 'required|string|max:20',
            'bank_account_id'       => 'required',
        ]);

        Carrier::create([
            "name"              => $request->name,
            "bank_account_id"   => $request->bank_account_id,
            "country"           => $request->country,
            "remarks"           => $request->remarks
        ]);

        return redirect()->route('carriers.index')
                         ->with('success', 'Carrier created Successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        return Inertia::render("App Settings/Carrier/Show", [
            "carrier"  => Carrier::with(['bankAccount'])->findOrFail($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $carrier = Carrier::findOrFail($id);
        
        return Inertia::render("App Settings/Carrier/Edit", [
            "carrier"  => $carrier,
            "bankAccounts" => BankAccount::all()
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name'       => 'required|string|max:20',
            'bank_account_id'       => 'required',
        ]);

       $carrier = Carrier::findOrFail($id);

        $carrier->update([
            "name"               => $request->name,
            "bank_account_id"    => $request->bank_account_id,
            "country"            => $request->country,
            "remarks"            => $request->remarks,
        ]);
        return redirect()->route('carriers.index')
                         ->with('success', 'Carrier updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $carrier = Carrier::findOrFail($id);
        $carrier->delete();
        return redirect()->route('carriers.index')
                        ->with('success', 'Carrier deleted Successfully!');
    }
}
