<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Client;
use App\Models\Payment;
use App\Models\PaymentDetail;
use App\Models\Invoice;
use App\Models\BankAccount;
use App\Models\BankAccountLedger;

class ClientController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return Inertia::render("App Settings/Client/Index", [
            "clients" => Client::all()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render("App Settings/Client/Create");
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'       => 'required|string|max:20',
            'phone'      => 'required|string|max:20',
        ]);

        Client::create([
            "name"              => $request->name,
            "passport_number"   => $request->passport_number,
            "address"           => $request->address,
            "phone"             => $request->phone,
        ]);

        return redirect()->route('clients.index')
                         ->with('success', 'Client created Successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        return Inertia::render("App Settings/Client/Show", [
            "client"  => Client::findOrFail($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $client = Client::findOrFail($id);
        return Inertia::render("App Settings/Client/Edit", [
            "client"  => $client,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
       $request->validate([
            'name'       => 'required|string|max:20',
            'phone'      => 'required|string|max:20',
        ]);

       $client = Client::findOrFail($id);

        $client->update([
            "name"               => $request->name,
            "passport_number"    => $request->passport_number,
            "address"            => $request->address,
            "phone"              => $request->phone,
        ]);
        return redirect()->route('clients.index')
                         ->with('success', 'Client updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $client = Client::findOrFail($id);
        $client->delete();
        return redirect()->route('clients.index')
                        ->with('success', 'Client deleted Successfully!');
    }

    public function creditClients()
    {
        $creditClient = Payment::with(['client'])->where('due_amount', '>', '0')->get();
        // dd($creditClient->toArray());
        return Inertia::render("App Settings/Client/Credit-Client", [
            "creditClient"  => $creditClient,
        ]);
    }

    public function editCreditClientsInvoice($id)
    {
        $credit_payment = Payment::with(['client', 'invoice'])->where('invoice_id', $id)->get();
        // dd($credit_payment->toArray());
        return Inertia::render("App Settings/Client/Credit-Client-Payment", [
            "credit_payment"  => $credit_payment,
        ]);
    }

    public function updateCreditClientsInvoice(Request $request, $invoice_id) 
    {
        $payment = Payment::where('invoice_id', $invoice_id)->first();
        $payment_details = new PaymentDetail();
        // $payment_paid_status = $request->paid_status;
        $payment->paid_amount =$request->paid_amount;
        $payment->due_amount = $request->due_amount;
        $payment_details->current_paid_amount = $request->new_paid_amount;
        $payment->save();
        $payment_details->invoice_id = $invoice_id;
        $payment_details->date = date('Y-m-d',strtotime($request->date));
        $payment_details->save();

        $invoice = Invoice::with('carrier')->findOrFail($invoice_id);

        $bankAccountId = $invoice->carrier->bank_account_id;

        $bankAccount = BankAccount::findOrFail($bankAccountId);

        $bankAccount['balance'] += $request->new_paid_amount;
        $bankAccount->save();

        $bankAccountLedger = new BankAccountLedger();

        $bankAccountLedger->bank_account_id = $bankAccountId;
        $bankAccountLedger->transaction_date = date('Y-m-d');
        $bankAccountLedger->reference = "Invoice Id " . $invoice_id;
        $bankAccountLedger->type = "debit";
        $bankAccountLedger->amount = $request->new_paid_amount;
        $bankAccountLedger->carrier_id = $invoice->carrier_id;
        $bankAccountLedger->client_id = $invoice->client_id;
        // $bankAccountLedger->description = 'New Payme';

        $bankAccountLedger->save();

        return redirect()->route('clients.credit-clients')->with('success', 'Invoice Successfully Updated');
    }

}
