<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Company;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return Inertia::render("App Settings/Company/Index", [
            "companies" => Company::all()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render("App Settings/Company/Create");
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'       => 'required|string|max:20',
        ]);

        Company::create([
            "name"      => $request->name,
            "address"   => $request->address,
            "phone"     => $request->phone,
        ]);

        return redirect()->route('companies.index')
                         ->with('success', 'Company created Successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
         return Inertia::render("App Settings/Company/Show", [
            "company"  => Company::findOrFail($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $company = Company::findOrFail($id);
        return Inertia::render("App Settings/Company/Edit", [
            "company"  => $company,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
       $request->validate([
            'name'       => 'required|string|max:20',
        ]);

       $company = Company::findOrFail($id);

        $company->update([
            "name"    => $request->name,
            "address" => $request->address,
            "phone"   => $request->phone,
        ]);
        return redirect()->route('companies.index')
                         ->with('success', 'Company updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $company = Company::findOrFail($id);
        $company->delete();
        return redirect()->route('companies.index')
                        ->with('success', 'Company deleted Successfully!');
    }

}
