<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Country;

class CountryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return Inertia::render("App Settings/Country/Index", [
            "countries" => Country::all()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render("App Settings/Country/Create");
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'       => 'required|string|max:50',
        ]);

        Country::create([
            "name"              => $request->name,
        ]);

        return redirect()->route('countries.index')
                         ->with('success', 'Country created Successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        return Inertia::render("App Settings/Country/Show", [
            "country"  => Country::findOrFail($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $country = Country::findOrFail($id);
        return Inertia::render("App Settings/Country/Edit", [
            "country"  => $country,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'name'       => 'required|string|max:50',
        ]);

       $country = Country::findOrFail($id);

        $country->update([
            "name"  => $request->name,
        ]);
        return redirect()->route('countries.index')
                         ->with('success', 'Country updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $country = Country::findOrFail($id);
        $country->delete();
        return redirect()->route('countries.index')
                        ->with('success', 'Country deleted Successfully!');
    }
}
