<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Inertia\Inertia;
use App\Models\Hotel;

class HotelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return Inertia::render("App Settings/Hotel/Index", [
            "hotels" => Hotel::all()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render("App Settings/Hotel/Create");
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'       => 'required|string|max:20',
        ]);

        Hotel::create([
            "name"      => $request->name,
            "address"   => $request->address,
            "phone"     => $request->phone,
        ]);

        return redirect()->route('hotels.index')
                         ->with('success', 'Hotel created Successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        return Inertia::render("App Settings/Hotel/Show", [
            "hotel"  => Hotel::findOrFail($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $hotel = Hotel::findOrFail($id);
        return Inertia::render("App Settings/Hotel/Edit", [
            "hotel"  => $hotel,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
       $request->validate([
            'name'       => 'required|string|max:20',
        ]);

       $hotel = Hotel::findOrFail($id);

        $hotel->update([
            "name"    => $request->name,
            "address" => $request->address,
            "phone"   => $request->phone,
        ]);
        return redirect()->route('hotels.index')
                         ->with('success', 'Hotel updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $hotel = Hotel::findOrFail($id);
        $hotel->delete();
        return redirect()->route('hotels.index')
                        ->with('success', 'Hotel deleted Successfully!');
    }
}
