<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\PaymentTerms;

class PaymentTermsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return Inertia::render("App Settings/Payment Terms/Index", [
            "payment_terms" => PaymentTerms::all()
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render("App Settings/Payment Terms/Create");
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'payment_terms'       => 'required|integer',
        ]);

        PaymentTerms::create([
            "payment_terms"     => $request->payment_terms,
            "remarks"           => $request->remarks,
        ]);

        return redirect()->route('payment-terms.index')
                         ->with('success', 'Payment Terms created Successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        return Inertia::render("App Settings/Payment Terms/Show", [
            "payment_term"  => PaymentTerms::findOrFail($id)
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $payment_term = PaymentTerms::findOrFail($id);
        return Inertia::render("App Settings/Payment Terms/Edit", [
            "payment_term"  => $payment_term,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'payment_terms'       => 'required|integer',
        ]);

       $payment_term = PaymentTerms::findOrFail($id);

        $payment_term->update([
            "payment_terms"    => $request->payment_terms,
            "remarks"          => $request->remarks,
        ]);
        return redirect()->route('payment-terms.index')
                         ->with('success', 'Payment Term updated Successfully!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $payment_term = PaymentTerms::findOrFail($id);
        $payment_term->delete();
        return redirect()->route('payment-terms.index')
                        ->with('success', 'Payment Term deleted Successfully!');
    }
}
