<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;

use App\Models\Carrier;
use App\Models\Invoice;
use App\Models\Income;
use App\Models\Expense;
use App\Models\BankAccountLedger;

class ReportController extends Controller
{
    public function invoiceReport(Request $request)
    {
        if($request->has(['startDate', 'endDate'])) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');

            $invoiceReports = Invoice::with('carrier:id,name')
                ->selectRaw('
                    carrier_id,
                    DATE(invoice_date) as invoice_date,
                    COUNT(*) as ticket_count,
                    SUM(sales_amount) as total_sales_amount,
                    SUM(purchase_amount) as total_purchase_amount,
                    SUM(profit_loss) as total_profit_loss
                ')
                ->whereBetween('invoice_date', [$startDate, $endDate])
                ->groupBy('carrier_id', 'invoice_date')
                ->orderBy('invoice_date', 'desc')
                ->get();

            return inertia('Reports/InvoiceReport', [
                'invoiceReports' => $invoiceReports,
                'filters' => [
                    'startDate' => $startDate,
                    'endDate' => $endDate,
                ],
            ]);
        } else {   
            $currentDate = date('Y-m-d');
            $invoiceReports = Invoice::with('carrier:id,name')
                ->selectRaw('
                    carrier_id,
                    DATE(invoice_date) as invoice_date,
                    COUNT(*) as ticket_count,
                    SUM(sales_amount) as total_sales_amount,
                    SUM(purchase_amount) as total_purchase_amount,
                    SUM(profit_loss) as total_profit_loss
                ')
                ->whereDate('invoice_date', $currentDate)
                ->groupBy('carrier_id', 'invoice_date')
                ->orderBy('invoice_date', 'desc')
                ->get();
            return inertia('Reports/InvoiceReport', [
                'invoiceReports' => $invoiceReports,
            ]);
        }
    }
    
    public function balanceSheetReport(Request $request)
    {
        if($request->has(['startDate', 'endDate'])) {
            $startDate = $request->input('startDate');
            $endDate = $request->input('endDate');

            $debits = BankAccountLedger::whereBetween('transaction_date', [$startDate, $endDate])
                ->where('type', 'debit')->get();

            $credits = BankAccountLedger::whereBetween('transaction_date', [$startDate, $endDate])
                ->where('type', 'credit')->get();

            return inertia('Reports/BalanceSheetReport', [
                'debits' => $debits,
                'credits' => $credits,
                'filters' => [
                    'startDate' => $startDate,
                    'endDate' => $endDate,
                ],
            ]);
        } else {   
            $currentDate = date('Y-m-d');
            $debits = BankAccountLedger::whereBetween('transaction_date', [$currentDate, $currentDate])
                    ->where('type', 'debit')->get();
            $credits = BankAccountLedger::whereBetween('transaction_date', [$currentDate, $currentDate])
                ->where('type', 'credit')->get();

            // dd( $incomes, $expenses);
            return inertia('Reports/BalanceSheetReport', [
                'debits' => $debits,
                'credits' => $credits,
            ]);
        }
    }
}
