<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BankAccount extends Model
{
    protected $fillable = [
        'account_name',
        'account_number',
        'bank_name',
        'branch_name',
        'ifsc_code',
        'balance',
    ];

    public function fundTransfersFrom()
    {
        return $this->hasMany(FundTransfer::class, 'from_account_id');
    }
    
    public function fundTransfersTo()
    {
        return $this->hasMany(FundTransfer::class, 'to_account_id');
    }

    public function carrier()
    {
        return $this->hasMany(Carrier::class, 'bank_account_id');
    }

    public function booking()
    {
        return $this->hasMany(HotelBooking::class, 'bank_account_id');
    }
}
