<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class HotelBooking extends Model
{
    
    use HasFactory;

    protected $fillable = [
        'date',
        'type',
        'client_id',
        'company_id',
        'date_from',
        'date_to',
        'base_fare',
        'tax',
        'mark_up',
        'purchase_com',
        'sales_com',
        'discount_lvl',
        'sales_amount',
        'purchase_amount',
        'profit_loss',
        'note',
        'bank_account_id',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'date' => 'date:Y-m-d',
        'date_from' => 'date:Y-m-d',
        'date_to' => 'date:Y-m-d',
        'base_fare' => 'decimal:2',
        'tax' => 'decimal:2',
        'mark_up' => 'decimal:2',
        'purchase_com' => 'decimal:2',
        'sales_com' => 'decimal:2',
        'discount_lvl' => 'decimal:2',
        'sales_amount' => 'decimal:2',
        'purchase_amount' => 'decimal:2',
        'profit_loss' => 'decimal:2',
    ];


    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function bankAccount()
    {
        return $this->belongsTo(BankAccount::class);
    }
}
