<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_date',
        'ticket_no',
        'client_id',
        'company_id',
        'carrier_id',
        'ticket_type',
        'flight_date',
        'base_fare',
        'tax',
        'mark_up',
        'purchase_com',
        'sales_com',
        'discount_lvl',
        'sales_amount',
        'purchase_amount',
        'profit_loss',
        'pnr',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'flight_date' => 'date',
        'base_fare' => 'decimal:2',
        'tax' => 'decimal:2',
        'mark_up' => 'decimal:2',
        'purchase_com' => 'decimal:2',
        'sales_com' => 'decimal:2',
        'discount_lvl' => 'decimal:2',
        'sales_amount' => 'decimal:2',
        'purchase_amount' => 'decimal:2',
        'profit_loss' => 'decimal:2',
    ];

    public function refunds()
    {
        return $this->hasMany(Refund::class);
    }

    public function payment()
    {
    	return $this->belongsTo(Payment::class, 'id', 'invoice_id');
    }

    public function invoice_details()
    {
    	return $this->hasMany(InvoiceDetail::class, 'invoice_id', 'id');
    }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function carrier()
    {
        return $this->belongsTo(carrier::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

}
