<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'order_number',
        'vendor_id',
        'order_date',
        'total_amount',
        'paid_amount',
        'due_amount',
        'paid_via',
        'status',
        'notes',
    ];

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }
}
