<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Refund extends Model
{
    use HasFactory;

    protected $fillable = [
        'refund_date',
        'invoice_id',
        'ticket_no',
        'refund_type',
        'sales_amount',
        'purchase_amount',
        'refundable_tax',
        'non_refundable',
        'cancellation_fee',
        'admin_fee',
        'carrier_refund_amount',
        'refund_amount',
    ];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

}
