<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vendor extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'type', // e.g., airline, hotel, transport
        'address',
        'phone',
        'email',
        'notes',
    ];

    public function purchase_orders()
    {
        return $this->hasMany(PurchaseOrder::class);
    }
}
