<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('invoice_no');
            $table->date('invoice_date');
            $table->string('ticket_no');
            $table->foreignId('client_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('company_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('carrier_id')->nullable()->constrained()->nullOnDelete();
            $table->string('ticket_type')->nullable();
            $table->date('flight_date');
            $table->decimal('base_fare', 12, 2)->default(0);
            $table->decimal('tax', 5, 2)->default(0);
            $table->decimal('mark_up', 5, 2)->default(0);
            $table->decimal('purchase_com', 5, 2)->default(0);
            $table->decimal('sales_com', 5, 2)->default(0);
            $table->decimal('discount_lvl', 5, 2)->default(0);
            $table->decimal('sales_amount', 12, 2)->default(0);
            $table->decimal('purchase_amount', 12, 2)->default(0);
            $table->decimal('profit_loss', 12, 2)->default(0);
            $table->string('pnr')->nullable();
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
