<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('refunds', function (Blueprint $table) {
            $table->id();
            $table->date('refund_date');
            $table->integer('invoice_id');
            $table->string('ticket_no');
            $table->string('refund_type')->nullable();
            $table->decimal('sales_amount', 12, 2)->default(0);
            $table->decimal('purchase_amount', 12, 2)->default(0);
            $table->decimal('refundable_tax', 5, 2)->default(0);
            $table->decimal('non_refundable', 5, 2)->default(0);
            $table->decimal('cancellation_fee', 12, 2)->default(0);
            $table->decimal('admin_fee', 12, 2)->default(0);
            $table->decimal('carrier_refund_amount', 12, 2)->default(0);
            $table->decimal('refund_amount', 12, 2)->default(0);
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('refunds');
    }
};
