<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bank_account_ledgers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('bank_account_id');
            $table->date('transaction_date');
            $table->string('reference')->nullable(); // e.g. invoice no, refund id
            $table->enum('type', ['credit', 'debit']);
            $table->decimal('amount', 12, 2);
            $table->string('description')->nullable(); // e.g. "Refund to Carrier", "Customer Payment"
            $table->foreignId('carrier_id')->nullable();
            $table->foreignId('client_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bank_account_ledgers');
    }
};
