<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // 2️⃣ Create an Admin role
        $adminRole = Role::firstOrCreate(['name' => 'Admin']);

        // 3️⃣ Give Admin all permissions
        $adminRole->syncPermissions(Permission::all());

        // 4️⃣ Create a Test Admin user
        $user = User::firstOrCreate(
            ['email' => 'admin@admin.com'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('12345678'), // 👈 default password
            ]
        );

        // 5️⃣ Assign Admin role to the user
        $user->assignRole($adminRole);

        $this->command->info('✅ Admin user created: admin@example.com / password');
    }
}
