<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            "users.view",
            "users.create",
            "users.edit",
            "users.destroy",
            "roles.view",
            "roles.create",
            "roles.edit",
            "roles.destroy"
        ];

        foreach($permissions as $key => $value) {
            Permission::create(["name" => $value]);
        }
    }
}
