import { ErrorValue, FormDataErrors, FormDataKeys, FormDataType, FormDataValues, Method, Progress, UrlMethodPair, VisitOptions } from '@inertiajs/core';
type FormOptions = Omit<VisitOptions, 'data'>;
export interface InertiaFormProps<TForm extends object> {
    isDirty: boolean;
    errors: FormDataErrors<TForm>;
    hasErrors: boolean;
    processing: boolean;
    progress: Progress | null;
    wasSuccessful: boolean;
    recentlySuccessful: boolean;
    data(): TForm;
    transform(callback: (data: TForm) => object): this;
    defaults(): this;
    defaults<T extends FormDataKeys<TForm>>(field: T, value: FormDataValues<TForm, T>): this;
    defaults(fields: Partial<TForm>): this;
    reset<K extends FormDataKeys<TForm>>(...fields: K[]): this;
    clearErrors<K extends FormDataKeys<TForm>>(...fields: K[]): this;
    resetAndClearErrors<K extends FormDataKeys<TForm>>(...fields: K[]): this;
    setError<K extends FormDataKeys<TForm>>(field: K, value: ErrorValue): this;
    setError(errors: FormDataErrors<TForm>): this;
    submit: (...args: [Method, string, FormOptions?] | [UrlMethodPair, FormOptions?]) => void;
    get(url: string, options?: FormOptions): void;
    post(url: string, options?: FormOptions): void;
    put(url: string, options?: FormOptions): void;
    patch(url: string, options?: FormOptions): void;
    delete(url: string, options?: FormOptions): void;
    cancel(): void;
}
export type InertiaForm<TForm extends object> = TForm & InertiaFormProps<TForm>;
export default function useForm<TForm extends FormDataType<TForm>>(data: TForm | (() => TForm)): InertiaForm<TForm>;
export default function useForm<TForm extends FormDataType<TForm>>(rememberKey: string, data: TForm | (() => TForm)): InertiaForm<TForm>;
export {};
