<br />
<p align="center">
  <a href="https://github.com/unovue/reka-ui">
    <img src="https://reka-ui.com/logo.svg" alt="Logo" width="150" />
  </a>

<h1 align="center">
Reka UI
</h1>

<p align="center">
Craft accessible web apps with <a href="https://vuejs.org/">Vue</a>.
<p>

<p align="center">
<a href="https://www.npmjs.com/package/reka-ui" target="__blank"><img src="https://img.shields.io/npm/v/reka-ui?style=flat&colorA=002438&colorB=41c399" alt="NPM version"></a>
<a href="https://www.npmjs.com/package/reka-ui" target="__blank"><img alt="NPM Downloads" src="https://img.shields.io/npm/dm/reka-ui?flat&colorA=002438&colorB=41c399"></a>
<a href="https://github.com/unovue/reka-ui" target="__blank"><img alt="GitHub stars" src="https://img.shields.io/github/stars/unovue/reka-ui?flat&colorA=002438&colorB=41c399"></a>
</p>

<p align="center">
<a href="https://chat.unovue.com"><b>Get involved!</b></a>
</p>
<p align="center">
 <a href="https://reka-ui.com">Documentation</a> | <a href="https://reka-ui.com/docs/overview/getting-started">Getting Started</a> | <a href="https://reka-ui.com/examples">Examples</a> | <a href="https://reka-ui.com/docs/overview/introduction">Why Reka UI?</a>
</p>

![hero image](https://reka-ui.com/og.jpg)
 <em>design by: [icarusgkx](https://twitter.com/icarusgkx), [melkam](https://github.com/MellKam)</em>

## Installation

```bash
pnpm add reka-ui
```
```bash
npm install reka-ui
```
```bash
yarn add reka-ui
```

## Documentation

For full documentation, visit [reka-ui.com](https://reka-ui.com).

## Releases

For changelog, visit [releases](https://github.com/unovue/reka-ui/releases).

## Contributing

We would love to have your contributions! All PRs are welcome! We need help building the core components, docs, tests, stories! [Join our discord](https://chat.unovue.com/) and we will get you up and running!

## Dev Setup

### Docs

1. Clone the repo
2. Run `pnpm i`
3. Run `pnpm build` to run build `reka-ui` locally
3. Run `pnpm docs:dev` to run vitepress
4. Open `http://localhost:5173`

### Package

1. Clone the repo
2. Run `pnpm i`
3. Run `pnpm story:dev` to run histoire (storybook)
4. Open `http://localhost:6006`
5. Run `pnpm test` to test changes

## Credits

All credits go to these open-source works and resources

- [Radix UI](https://radix-ui.com)
- [React Spectrum](https://react-spectrum.adobe.com/index.html)
- [Floating UI](https://floating-ui.com)
- [Headless UI](https://headlessui.com)
