import { useForwardExpose } from "../shared/useForwardExpose.js";
import { DialogTitle_default } from "../Dialog/DialogTitle.js";
import { createBlock, defineComponent, guardReactiveProps, normalizeProps, openBlock, renderSlot, unref, withCtx } from "vue";

//#region src/AlertDialog/AlertDialogTitle.vue?vue&type=script&setup=true&lang.ts
var AlertDialogTitle_vue_vue_type_script_setup_true_lang_default = /* @__PURE__ */ defineComponent({
	__name: "AlertDialogTitle",
	props: {
		asChild: {
			type: Boolean,
			required: false
		},
		as: {
			type: null,
			required: false,
			default: "h2"
		}
	},
	setup(__props) {
		const props = __props;
		useForwardExpose();
		return (_ctx, _cache) => {
			return openBlock(), createBlock(unref(DialogTitle_default), normalizeProps(guardReactiveProps(props)), {
				default: withCtx(() => [renderSlot(_ctx.$slots, "default")]),
				_: 3
			}, 16);
		};
	}
});

//#endregion
//#region src/AlertDialog/AlertDialogTitle.vue
var AlertDialogTitle_default = AlertDialogTitle_vue_vue_type_script_setup_true_lang_default;

//#endregion
export { AlertDialogTitle_default };
//# sourceMappingURL=AlertDialogTitle.js.map