import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\ClientController::create
 * @see app/Http/Controllers/ClientController.php:29
 * @route '/clients/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/clients/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ClientController::create
 * @see app/Http/Controllers/ClientController.php:29
 * @route '/clients/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::create
 * @see app/Http/Controllers/ClientController.php:29
 * @route '/clients/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ClientController::create
 * @see app/Http/Controllers/ClientController.php:29
 * @route '/clients/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ClientController::create
 * @see app/Http/Controllers/ClientController.php:29
 * @route '/clients/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ClientController::create
 * @see app/Http/Controllers/ClientController.php:29
 * @route '/clients/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ClientController::create
 * @see app/Http/Controllers/ClientController.php:29
 * @route '/clients/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\ClientController::store
 * @see app/Http/Controllers/ClientController.php:37
 * @route '/clients'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/clients',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\ClientController::store
 * @see app/Http/Controllers/ClientController.php:37
 * @route '/clients'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::store
 * @see app/Http/Controllers/ClientController.php:37
 * @route '/clients'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\ClientController::store
 * @see app/Http/Controllers/ClientController.php:37
 * @route '/clients'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\ClientController::store
 * @see app/Http/Controllers/ClientController.php:37
 * @route '/clients'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\ClientController::edit
 * @see app/Http/Controllers/ClientController.php:68
 * @route '/clients/{client}/edit'
 */
export const edit = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/clients/{client}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ClientController::edit
 * @see app/Http/Controllers/ClientController.php:68
 * @route '/clients/{client}/edit'
 */
edit.url = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { client: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    client: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        client: args.client,
                }

    return edit.definition.url
            .replace('{client}', parsedArgs.client.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::edit
 * @see app/Http/Controllers/ClientController.php:68
 * @route '/clients/{client}/edit'
 */
edit.get = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ClientController::edit
 * @see app/Http/Controllers/ClientController.php:68
 * @route '/clients/{client}/edit'
 */
edit.head = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ClientController::edit
 * @see app/Http/Controllers/ClientController.php:68
 * @route '/clients/{client}/edit'
 */
    const editForm = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ClientController::edit
 * @see app/Http/Controllers/ClientController.php:68
 * @route '/clients/{client}/edit'
 */
        editForm.get = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ClientController::edit
 * @see app/Http/Controllers/ClientController.php:68
 * @route '/clients/{client}/edit'
 */
        editForm.head = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\ClientController::update
 * @see app/Http/Controllers/ClientController.php:79
 * @route '/clients/{client}'
 */
export const update = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/clients/{client}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\ClientController::update
 * @see app/Http/Controllers/ClientController.php:79
 * @route '/clients/{client}'
 */
update.url = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { client: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    client: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        client: args.client,
                }

    return update.definition.url
            .replace('{client}', parsedArgs.client.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::update
 * @see app/Http/Controllers/ClientController.php:79
 * @route '/clients/{client}'
 */
update.put = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\ClientController::update
 * @see app/Http/Controllers/ClientController.php:79
 * @route '/clients/{client}'
 */
update.patch = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\ClientController::update
 * @see app/Http/Controllers/ClientController.php:79
 * @route '/clients/{client}'
 */
    const updateForm = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\ClientController::update
 * @see app/Http/Controllers/ClientController.php:79
 * @route '/clients/{client}'
 */
        updateForm.put = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\ClientController::update
 * @see app/Http/Controllers/ClientController.php:79
 * @route '/clients/{client}'
 */
        updateForm.patch = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\ClientController::destroy
 * @see app/Http/Controllers/ClientController.php:101
 * @route '/clients/{client}'
 */
export const destroy = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/clients/{client}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\ClientController::destroy
 * @see app/Http/Controllers/ClientController.php:101
 * @route '/clients/{client}'
 */
destroy.url = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { client: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    client: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        client: args.client,
                }

    return destroy.definition.url
            .replace('{client}', parsedArgs.client.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::destroy
 * @see app/Http/Controllers/ClientController.php:101
 * @route '/clients/{client}'
 */
destroy.delete = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\ClientController::destroy
 * @see app/Http/Controllers/ClientController.php:101
 * @route '/clients/{client}'
 */
    const destroyForm = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\ClientController::destroy
 * @see app/Http/Controllers/ClientController.php:101
 * @route '/clients/{client}'
 */
        destroyForm.delete = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\ClientController::index
 * @see app/Http/Controllers/ClientController.php:19
 * @route '/clients'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/clients',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ClientController::index
 * @see app/Http/Controllers/ClientController.php:19
 * @route '/clients'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::index
 * @see app/Http/Controllers/ClientController.php:19
 * @route '/clients'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ClientController::index
 * @see app/Http/Controllers/ClientController.php:19
 * @route '/clients'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ClientController::index
 * @see app/Http/Controllers/ClientController.php:19
 * @route '/clients'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ClientController::index
 * @see app/Http/Controllers/ClientController.php:19
 * @route '/clients'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ClientController::index
 * @see app/Http/Controllers/ClientController.php:19
 * @route '/clients'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\ClientController::show
 * @see app/Http/Controllers/ClientController.php:58
 * @route '/clients/{client}'
 */
export const show = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/clients/{client}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ClientController::show
 * @see app/Http/Controllers/ClientController.php:58
 * @route '/clients/{client}'
 */
show.url = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { client: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    client: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        client: args.client,
                }

    return show.definition.url
            .replace('{client}', parsedArgs.client.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::show
 * @see app/Http/Controllers/ClientController.php:58
 * @route '/clients/{client}'
 */
show.get = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ClientController::show
 * @see app/Http/Controllers/ClientController.php:58
 * @route '/clients/{client}'
 */
show.head = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ClientController::show
 * @see app/Http/Controllers/ClientController.php:58
 * @route '/clients/{client}'
 */
    const showForm = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ClientController::show
 * @see app/Http/Controllers/ClientController.php:58
 * @route '/clients/{client}'
 */
        showForm.get = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ClientController::show
 * @see app/Http/Controllers/ClientController.php:58
 * @route '/clients/{client}'
 */
        showForm.head = (args: { client: string | number } | [client: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
/**
* @see \App\Http\Controllers\ClientController::creditClients
 * @see app/Http/Controllers/ClientController.php:109
 * @route '/credit/clients'
 */
export const creditClients = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: creditClients.url(options),
    method: 'get',
})

creditClients.definition = {
    methods: ["get","head"],
    url: '/credit/clients',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ClientController::creditClients
 * @see app/Http/Controllers/ClientController.php:109
 * @route '/credit/clients'
 */
creditClients.url = (options?: RouteQueryOptions) => {
    return creditClients.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::creditClients
 * @see app/Http/Controllers/ClientController.php:109
 * @route '/credit/clients'
 */
creditClients.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: creditClients.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ClientController::creditClients
 * @see app/Http/Controllers/ClientController.php:109
 * @route '/credit/clients'
 */
creditClients.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: creditClients.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ClientController::creditClients
 * @see app/Http/Controllers/ClientController.php:109
 * @route '/credit/clients'
 */
    const creditClientsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: creditClients.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ClientController::creditClients
 * @see app/Http/Controllers/ClientController.php:109
 * @route '/credit/clients'
 */
        creditClientsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: creditClients.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ClientController::creditClients
 * @see app/Http/Controllers/ClientController.php:109
 * @route '/credit/clients'
 */
        creditClientsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: creditClients.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    creditClients.form = creditClientsForm
/**
* @see \App\Http\Controllers\ClientController::editCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
export const editCreditClientsInvoice = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: editCreditClientsInvoice.url(args, options),
    method: 'get',
})

editCreditClientsInvoice.definition = {
    methods: ["get","head"],
    url: '/credit/clients/invoice/edit/{invoice_id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ClientController::editCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
editCreditClientsInvoice.url = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { invoice_id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    invoice_id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        invoice_id: args.invoice_id,
                }

    return editCreditClientsInvoice.definition.url
            .replace('{invoice_id}', parsedArgs.invoice_id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::editCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
editCreditClientsInvoice.get = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: editCreditClientsInvoice.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ClientController::editCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
editCreditClientsInvoice.head = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: editCreditClientsInvoice.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ClientController::editCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
    const editCreditClientsInvoiceForm = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: editCreditClientsInvoice.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ClientController::editCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
        editCreditClientsInvoiceForm.get = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: editCreditClientsInvoice.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ClientController::editCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
        editCreditClientsInvoiceForm.head = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: editCreditClientsInvoice.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    editCreditClientsInvoice.form = editCreditClientsInvoiceForm
/**
* @see \App\Http\Controllers\ClientController::updateCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
export const updateCreditClientsInvoice = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateCreditClientsInvoice.url(args, options),
    method: 'put',
})

updateCreditClientsInvoice.definition = {
    methods: ["put"],
    url: '/credit/clients/invoice/update/{invoice_id}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\ClientController::updateCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
updateCreditClientsInvoice.url = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { invoice_id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    invoice_id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        invoice_id: args.invoice_id,
                }

    return updateCreditClientsInvoice.definition.url
            .replace('{invoice_id}', parsedArgs.invoice_id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::updateCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
updateCreditClientsInvoice.put = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: updateCreditClientsInvoice.url(args, options),
    method: 'put',
})

    /**
* @see \App\Http\Controllers\ClientController::updateCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
    const updateCreditClientsInvoiceForm = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: updateCreditClientsInvoice.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\ClientController::updateCreditClientsInvoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
        updateCreditClientsInvoiceForm.put = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: updateCreditClientsInvoice.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    updateCreditClientsInvoice.form = updateCreditClientsInvoiceForm
const ClientController = { create, store, edit, update, destroy, index, show, creditClients, editCreditClientsInvoice, updateCreditClientsInvoice }

export default ClientController