import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\FundTransferController::create
 * @see app/Http/Controllers/FundTransferController.php:43
 * @route '/fund-transfers/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/fund-transfers/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\FundTransferController::create
 * @see app/Http/Controllers/FundTransferController.php:43
 * @route '/fund-transfers/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\FundTransferController::create
 * @see app/Http/Controllers/FundTransferController.php:43
 * @route '/fund-transfers/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\FundTransferController::create
 * @see app/Http/Controllers/FundTransferController.php:43
 * @route '/fund-transfers/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\FundTransferController::create
 * @see app/Http/Controllers/FundTransferController.php:43
 * @route '/fund-transfers/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\FundTransferController::create
 * @see app/Http/Controllers/FundTransferController.php:43
 * @route '/fund-transfers/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\FundTransferController::create
 * @see app/Http/Controllers/FundTransferController.php:43
 * @route '/fund-transfers/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\FundTransferController::store
 * @see app/Http/Controllers/FundTransferController.php:51
 * @route '/fund-transfers'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/fund-transfers',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\FundTransferController::store
 * @see app/Http/Controllers/FundTransferController.php:51
 * @route '/fund-transfers'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\FundTransferController::store
 * @see app/Http/Controllers/FundTransferController.php:51
 * @route '/fund-transfers'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\FundTransferController::store
 * @see app/Http/Controllers/FundTransferController.php:51
 * @route '/fund-transfers'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\FundTransferController::store
 * @see app/Http/Controllers/FundTransferController.php:51
 * @route '/fund-transfers'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\FundTransferController::edit
 * @see app/Http/Controllers/FundTransferController.php:144
 * @route '/fund-transfers/{fund_transfer}/edit'
 */
export const edit = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/fund-transfers/{fund_transfer}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\FundTransferController::edit
 * @see app/Http/Controllers/FundTransferController.php:144
 * @route '/fund-transfers/{fund_transfer}/edit'
 */
edit.url = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { fund_transfer: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    fund_transfer: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        fund_transfer: args.fund_transfer,
                }

    return edit.definition.url
            .replace('{fund_transfer}', parsedArgs.fund_transfer.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\FundTransferController::edit
 * @see app/Http/Controllers/FundTransferController.php:144
 * @route '/fund-transfers/{fund_transfer}/edit'
 */
edit.get = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\FundTransferController::edit
 * @see app/Http/Controllers/FundTransferController.php:144
 * @route '/fund-transfers/{fund_transfer}/edit'
 */
edit.head = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\FundTransferController::edit
 * @see app/Http/Controllers/FundTransferController.php:144
 * @route '/fund-transfers/{fund_transfer}/edit'
 */
    const editForm = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\FundTransferController::edit
 * @see app/Http/Controllers/FundTransferController.php:144
 * @route '/fund-transfers/{fund_transfer}/edit'
 */
        editForm.get = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\FundTransferController::edit
 * @see app/Http/Controllers/FundTransferController.php:144
 * @route '/fund-transfers/{fund_transfer}/edit'
 */
        editForm.head = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\FundTransferController::update
 * @see app/Http/Controllers/FundTransferController.php:161
 * @route '/fund-transfers/{fund_transfer}'
 */
export const update = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/fund-transfers/{fund_transfer}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\FundTransferController::update
 * @see app/Http/Controllers/FundTransferController.php:161
 * @route '/fund-transfers/{fund_transfer}'
 */
update.url = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { fund_transfer: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    fund_transfer: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        fund_transfer: args.fund_transfer,
                }

    return update.definition.url
            .replace('{fund_transfer}', parsedArgs.fund_transfer.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\FundTransferController::update
 * @see app/Http/Controllers/FundTransferController.php:161
 * @route '/fund-transfers/{fund_transfer}'
 */
update.put = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\FundTransferController::update
 * @see app/Http/Controllers/FundTransferController.php:161
 * @route '/fund-transfers/{fund_transfer}'
 */
update.patch = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\FundTransferController::update
 * @see app/Http/Controllers/FundTransferController.php:161
 * @route '/fund-transfers/{fund_transfer}'
 */
    const updateForm = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\FundTransferController::update
 * @see app/Http/Controllers/FundTransferController.php:161
 * @route '/fund-transfers/{fund_transfer}'
 */
        updateForm.put = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\FundTransferController::update
 * @see app/Http/Controllers/FundTransferController.php:161
 * @route '/fund-transfers/{fund_transfer}'
 */
        updateForm.patch = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\FundTransferController::destroy
 * @see app/Http/Controllers/FundTransferController.php:218
 * @route '/fund-transfers/{fund_transfer}'
 */
export const destroy = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/fund-transfers/{fund_transfer}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\FundTransferController::destroy
 * @see app/Http/Controllers/FundTransferController.php:218
 * @route '/fund-transfers/{fund_transfer}'
 */
destroy.url = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { fund_transfer: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    fund_transfer: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        fund_transfer: args.fund_transfer,
                }

    return destroy.definition.url
            .replace('{fund_transfer}', parsedArgs.fund_transfer.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\FundTransferController::destroy
 * @see app/Http/Controllers/FundTransferController.php:218
 * @route '/fund-transfers/{fund_transfer}'
 */
destroy.delete = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\FundTransferController::destroy
 * @see app/Http/Controllers/FundTransferController.php:218
 * @route '/fund-transfers/{fund_transfer}'
 */
    const destroyForm = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\FundTransferController::destroy
 * @see app/Http/Controllers/FundTransferController.php:218
 * @route '/fund-transfers/{fund_transfer}'
 */
        destroyForm.delete = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\FundTransferController::index
 * @see app/Http/Controllers/FundTransferController.php:15
 * @route '/fund-transfers'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/fund-transfers',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\FundTransferController::index
 * @see app/Http/Controllers/FundTransferController.php:15
 * @route '/fund-transfers'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\FundTransferController::index
 * @see app/Http/Controllers/FundTransferController.php:15
 * @route '/fund-transfers'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\FundTransferController::index
 * @see app/Http/Controllers/FundTransferController.php:15
 * @route '/fund-transfers'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\FundTransferController::index
 * @see app/Http/Controllers/FundTransferController.php:15
 * @route '/fund-transfers'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\FundTransferController::index
 * @see app/Http/Controllers/FundTransferController.php:15
 * @route '/fund-transfers'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\FundTransferController::index
 * @see app/Http/Controllers/FundTransferController.php:15
 * @route '/fund-transfers'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\FundTransferController::show
 * @see app/Http/Controllers/FundTransferController.php:119
 * @route '/fund-transfers/{fund_transfer}'
 */
export const show = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/fund-transfers/{fund_transfer}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\FundTransferController::show
 * @see app/Http/Controllers/FundTransferController.php:119
 * @route '/fund-transfers/{fund_transfer}'
 */
show.url = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { fund_transfer: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    fund_transfer: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        fund_transfer: args.fund_transfer,
                }

    return show.definition.url
            .replace('{fund_transfer}', parsedArgs.fund_transfer.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\FundTransferController::show
 * @see app/Http/Controllers/FundTransferController.php:119
 * @route '/fund-transfers/{fund_transfer}'
 */
show.get = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\FundTransferController::show
 * @see app/Http/Controllers/FundTransferController.php:119
 * @route '/fund-transfers/{fund_transfer}'
 */
show.head = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\FundTransferController::show
 * @see app/Http/Controllers/FundTransferController.php:119
 * @route '/fund-transfers/{fund_transfer}'
 */
    const showForm = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\FundTransferController::show
 * @see app/Http/Controllers/FundTransferController.php:119
 * @route '/fund-transfers/{fund_transfer}'
 */
        showForm.get = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\FundTransferController::show
 * @see app/Http/Controllers/FundTransferController.php:119
 * @route '/fund-transfers/{fund_transfer}'
 */
        showForm.head = (args: { fund_transfer: string | number } | [fund_transfer: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
const FundTransferController = { create, store, edit, update, destroy, index, show }

export default FundTransferController