import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\HotelController::create
 * @see app/Http/Controllers/HotelController.php:25
 * @route '/hotels/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/hotels/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelController::create
 * @see app/Http/Controllers/HotelController.php:25
 * @route '/hotels/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelController::create
 * @see app/Http/Controllers/HotelController.php:25
 * @route '/hotels/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelController::create
 * @see app/Http/Controllers/HotelController.php:25
 * @route '/hotels/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelController::create
 * @see app/Http/Controllers/HotelController.php:25
 * @route '/hotels/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelController::create
 * @see app/Http/Controllers/HotelController.php:25
 * @route '/hotels/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelController::create
 * @see app/Http/Controllers/HotelController.php:25
 * @route '/hotels/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\HotelController::store
 * @see app/Http/Controllers/HotelController.php:33
 * @route '/hotels'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/hotels',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\HotelController::store
 * @see app/Http/Controllers/HotelController.php:33
 * @route '/hotels'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelController::store
 * @see app/Http/Controllers/HotelController.php:33
 * @route '/hotels'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\HotelController::store
 * @see app/Http/Controllers/HotelController.php:33
 * @route '/hotels'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HotelController::store
 * @see app/Http/Controllers/HotelController.php:33
 * @route '/hotels'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\HotelController::edit
 * @see app/Http/Controllers/HotelController.php:62
 * @route '/hotels/{hotel}/edit'
 */
export const edit = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/hotels/{hotel}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelController::edit
 * @see app/Http/Controllers/HotelController.php:62
 * @route '/hotels/{hotel}/edit'
 */
edit.url = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel: args.hotel,
                }

    return edit.definition.url
            .replace('{hotel}', parsedArgs.hotel.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelController::edit
 * @see app/Http/Controllers/HotelController.php:62
 * @route '/hotels/{hotel}/edit'
 */
edit.get = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelController::edit
 * @see app/Http/Controllers/HotelController.php:62
 * @route '/hotels/{hotel}/edit'
 */
edit.head = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelController::edit
 * @see app/Http/Controllers/HotelController.php:62
 * @route '/hotels/{hotel}/edit'
 */
    const editForm = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelController::edit
 * @see app/Http/Controllers/HotelController.php:62
 * @route '/hotels/{hotel}/edit'
 */
        editForm.get = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelController::edit
 * @see app/Http/Controllers/HotelController.php:62
 * @route '/hotels/{hotel}/edit'
 */
        editForm.head = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\HotelController::update
 * @see app/Http/Controllers/HotelController.php:73
 * @route '/hotels/{hotel}'
 */
export const update = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/hotels/{hotel}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\HotelController::update
 * @see app/Http/Controllers/HotelController.php:73
 * @route '/hotels/{hotel}'
 */
update.url = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel: args.hotel,
                }

    return update.definition.url
            .replace('{hotel}', parsedArgs.hotel.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelController::update
 * @see app/Http/Controllers/HotelController.php:73
 * @route '/hotels/{hotel}'
 */
update.put = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\HotelController::update
 * @see app/Http/Controllers/HotelController.php:73
 * @route '/hotels/{hotel}'
 */
update.patch = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\HotelController::update
 * @see app/Http/Controllers/HotelController.php:73
 * @route '/hotels/{hotel}'
 */
    const updateForm = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HotelController::update
 * @see app/Http/Controllers/HotelController.php:73
 * @route '/hotels/{hotel}'
 */
        updateForm.put = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\HotelController::update
 * @see app/Http/Controllers/HotelController.php:73
 * @route '/hotels/{hotel}'
 */
        updateForm.patch = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\HotelController::destroy
 * @see app/Http/Controllers/HotelController.php:93
 * @route '/hotels/{hotel}'
 */
export const destroy = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/hotels/{hotel}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\HotelController::destroy
 * @see app/Http/Controllers/HotelController.php:93
 * @route '/hotels/{hotel}'
 */
destroy.url = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel: args.hotel,
                }

    return destroy.definition.url
            .replace('{hotel}', parsedArgs.hotel.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelController::destroy
 * @see app/Http/Controllers/HotelController.php:93
 * @route '/hotels/{hotel}'
 */
destroy.delete = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\HotelController::destroy
 * @see app/Http/Controllers/HotelController.php:93
 * @route '/hotels/{hotel}'
 */
    const destroyForm = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HotelController::destroy
 * @see app/Http/Controllers/HotelController.php:93
 * @route '/hotels/{hotel}'
 */
        destroyForm.delete = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\HotelController::index
 * @see app/Http/Controllers/HotelController.php:15
 * @route '/hotels'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/hotels',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelController::index
 * @see app/Http/Controllers/HotelController.php:15
 * @route '/hotels'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelController::index
 * @see app/Http/Controllers/HotelController.php:15
 * @route '/hotels'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelController::index
 * @see app/Http/Controllers/HotelController.php:15
 * @route '/hotels'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelController::index
 * @see app/Http/Controllers/HotelController.php:15
 * @route '/hotels'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelController::index
 * @see app/Http/Controllers/HotelController.php:15
 * @route '/hotels'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelController::index
 * @see app/Http/Controllers/HotelController.php:15
 * @route '/hotels'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\HotelController::show
 * @see app/Http/Controllers/HotelController.php:52
 * @route '/hotels/{hotel}'
 */
export const show = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/hotels/{hotel}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelController::show
 * @see app/Http/Controllers/HotelController.php:52
 * @route '/hotels/{hotel}'
 */
show.url = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel: args.hotel,
                }

    return show.definition.url
            .replace('{hotel}', parsedArgs.hotel.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelController::show
 * @see app/Http/Controllers/HotelController.php:52
 * @route '/hotels/{hotel}'
 */
show.get = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelController::show
 * @see app/Http/Controllers/HotelController.php:52
 * @route '/hotels/{hotel}'
 */
show.head = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelController::show
 * @see app/Http/Controllers/HotelController.php:52
 * @route '/hotels/{hotel}'
 */
    const showForm = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelController::show
 * @see app/Http/Controllers/HotelController.php:52
 * @route '/hotels/{hotel}'
 */
        showForm.get = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelController::show
 * @see app/Http/Controllers/HotelController.php:52
 * @route '/hotels/{hotel}'
 */
        showForm.head = (args: { hotel: string | number } | [hotel: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
const HotelController = { create, store, edit, update, destroy, index, show }

export default HotelController