import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\PaymentTermsController::create
 * @see app/Http/Controllers/PaymentTermsController.php:24
 * @route '/payment-terms/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/payment-terms/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaymentTermsController::create
 * @see app/Http/Controllers/PaymentTermsController.php:24
 * @route '/payment-terms/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaymentTermsController::create
 * @see app/Http/Controllers/PaymentTermsController.php:24
 * @route '/payment-terms/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaymentTermsController::create
 * @see app/Http/Controllers/PaymentTermsController.php:24
 * @route '/payment-terms/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaymentTermsController::create
 * @see app/Http/Controllers/PaymentTermsController.php:24
 * @route '/payment-terms/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaymentTermsController::create
 * @see app/Http/Controllers/PaymentTermsController.php:24
 * @route '/payment-terms/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaymentTermsController::create
 * @see app/Http/Controllers/PaymentTermsController.php:24
 * @route '/payment-terms/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\PaymentTermsController::store
 * @see app/Http/Controllers/PaymentTermsController.php:32
 * @route '/payment-terms'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/payment-terms',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\PaymentTermsController::store
 * @see app/Http/Controllers/PaymentTermsController.php:32
 * @route '/payment-terms'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaymentTermsController::store
 * @see app/Http/Controllers/PaymentTermsController.php:32
 * @route '/payment-terms'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\PaymentTermsController::store
 * @see app/Http/Controllers/PaymentTermsController.php:32
 * @route '/payment-terms'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PaymentTermsController::store
 * @see app/Http/Controllers/PaymentTermsController.php:32
 * @route '/payment-terms'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\PaymentTermsController::edit
 * @see app/Http/Controllers/PaymentTermsController.php:60
 * @route '/payment-terms/{payment_term}/edit'
 */
export const edit = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/payment-terms/{payment_term}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaymentTermsController::edit
 * @see app/Http/Controllers/PaymentTermsController.php:60
 * @route '/payment-terms/{payment_term}/edit'
 */
edit.url = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { payment_term: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    payment_term: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        payment_term: args.payment_term,
                }

    return edit.definition.url
            .replace('{payment_term}', parsedArgs.payment_term.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaymentTermsController::edit
 * @see app/Http/Controllers/PaymentTermsController.php:60
 * @route '/payment-terms/{payment_term}/edit'
 */
edit.get = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaymentTermsController::edit
 * @see app/Http/Controllers/PaymentTermsController.php:60
 * @route '/payment-terms/{payment_term}/edit'
 */
edit.head = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaymentTermsController::edit
 * @see app/Http/Controllers/PaymentTermsController.php:60
 * @route '/payment-terms/{payment_term}/edit'
 */
    const editForm = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaymentTermsController::edit
 * @see app/Http/Controllers/PaymentTermsController.php:60
 * @route '/payment-terms/{payment_term}/edit'
 */
        editForm.get = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaymentTermsController::edit
 * @see app/Http/Controllers/PaymentTermsController.php:60
 * @route '/payment-terms/{payment_term}/edit'
 */
        editForm.head = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\PaymentTermsController::update
 * @see app/Http/Controllers/PaymentTermsController.php:71
 * @route '/payment-terms/{payment_term}'
 */
export const update = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/payment-terms/{payment_term}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\PaymentTermsController::update
 * @see app/Http/Controllers/PaymentTermsController.php:71
 * @route '/payment-terms/{payment_term}'
 */
update.url = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { payment_term: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    payment_term: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        payment_term: args.payment_term,
                }

    return update.definition.url
            .replace('{payment_term}', parsedArgs.payment_term.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaymentTermsController::update
 * @see app/Http/Controllers/PaymentTermsController.php:71
 * @route '/payment-terms/{payment_term}'
 */
update.put = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\PaymentTermsController::update
 * @see app/Http/Controllers/PaymentTermsController.php:71
 * @route '/payment-terms/{payment_term}'
 */
update.patch = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\PaymentTermsController::update
 * @see app/Http/Controllers/PaymentTermsController.php:71
 * @route '/payment-terms/{payment_term}'
 */
    const updateForm = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PaymentTermsController::update
 * @see app/Http/Controllers/PaymentTermsController.php:71
 * @route '/payment-terms/{payment_term}'
 */
        updateForm.put = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\PaymentTermsController::update
 * @see app/Http/Controllers/PaymentTermsController.php:71
 * @route '/payment-terms/{payment_term}'
 */
        updateForm.patch = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\PaymentTermsController::destroy
 * @see app/Http/Controllers/PaymentTermsController.php:90
 * @route '/payment-terms/{payment_term}'
 */
export const destroy = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/payment-terms/{payment_term}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\PaymentTermsController::destroy
 * @see app/Http/Controllers/PaymentTermsController.php:90
 * @route '/payment-terms/{payment_term}'
 */
destroy.url = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { payment_term: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    payment_term: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        payment_term: args.payment_term,
                }

    return destroy.definition.url
            .replace('{payment_term}', parsedArgs.payment_term.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaymentTermsController::destroy
 * @see app/Http/Controllers/PaymentTermsController.php:90
 * @route '/payment-terms/{payment_term}'
 */
destroy.delete = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\PaymentTermsController::destroy
 * @see app/Http/Controllers/PaymentTermsController.php:90
 * @route '/payment-terms/{payment_term}'
 */
    const destroyForm = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\PaymentTermsController::destroy
 * @see app/Http/Controllers/PaymentTermsController.php:90
 * @route '/payment-terms/{payment_term}'
 */
        destroyForm.delete = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\PaymentTermsController::index
 * @see app/Http/Controllers/PaymentTermsController.php:14
 * @route '/payment-terms'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/payment-terms',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaymentTermsController::index
 * @see app/Http/Controllers/PaymentTermsController.php:14
 * @route '/payment-terms'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaymentTermsController::index
 * @see app/Http/Controllers/PaymentTermsController.php:14
 * @route '/payment-terms'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaymentTermsController::index
 * @see app/Http/Controllers/PaymentTermsController.php:14
 * @route '/payment-terms'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaymentTermsController::index
 * @see app/Http/Controllers/PaymentTermsController.php:14
 * @route '/payment-terms'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaymentTermsController::index
 * @see app/Http/Controllers/PaymentTermsController.php:14
 * @route '/payment-terms'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaymentTermsController::index
 * @see app/Http/Controllers/PaymentTermsController.php:14
 * @route '/payment-terms'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\PaymentTermsController::show
 * @see app/Http/Controllers/PaymentTermsController.php:50
 * @route '/payment-terms/{payment_term}'
 */
export const show = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/payment-terms/{payment_term}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\PaymentTermsController::show
 * @see app/Http/Controllers/PaymentTermsController.php:50
 * @route '/payment-terms/{payment_term}'
 */
show.url = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { payment_term: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    payment_term: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        payment_term: args.payment_term,
                }

    return show.definition.url
            .replace('{payment_term}', parsedArgs.payment_term.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\PaymentTermsController::show
 * @see app/Http/Controllers/PaymentTermsController.php:50
 * @route '/payment-terms/{payment_term}'
 */
show.get = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\PaymentTermsController::show
 * @see app/Http/Controllers/PaymentTermsController.php:50
 * @route '/payment-terms/{payment_term}'
 */
show.head = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\PaymentTermsController::show
 * @see app/Http/Controllers/PaymentTermsController.php:50
 * @route '/payment-terms/{payment_term}'
 */
    const showForm = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\PaymentTermsController::show
 * @see app/Http/Controllers/PaymentTermsController.php:50
 * @route '/payment-terms/{payment_term}'
 */
        showForm.get = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\PaymentTermsController::show
 * @see app/Http/Controllers/PaymentTermsController.php:50
 * @route '/payment-terms/{payment_term}'
 */
        showForm.head = (args: { payment_term: string | number } | [payment_term: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
const PaymentTermsController = { create, store, edit, update, destroy, index, show }

export default PaymentTermsController