import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\ReportController::invoiceReport
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
export const invoiceReport = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: invoiceReport.url(options),
    method: 'get',
})

invoiceReport.definition = {
    methods: ["get","head"],
    url: '/reports/invoices',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ReportController::invoiceReport
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
invoiceReport.url = (options?: RouteQueryOptions) => {
    return invoiceReport.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ReportController::invoiceReport
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
invoiceReport.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: invoiceReport.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ReportController::invoiceReport
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
invoiceReport.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: invoiceReport.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ReportController::invoiceReport
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
    const invoiceReportForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: invoiceReport.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ReportController::invoiceReport
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
        invoiceReportForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: invoiceReport.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ReportController::invoiceReport
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
        invoiceReportForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: invoiceReport.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    invoiceReport.form = invoiceReportForm
/**
* @see \App\Http\Controllers\ReportController::balanceSheetReport
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
export const balanceSheetReport = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: balanceSheetReport.url(options),
    method: 'get',
})

balanceSheetReport.definition = {
    methods: ["get","head"],
    url: '/reports/balance-sheet',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ReportController::balanceSheetReport
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
balanceSheetReport.url = (options?: RouteQueryOptions) => {
    return balanceSheetReport.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ReportController::balanceSheetReport
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
balanceSheetReport.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: balanceSheetReport.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ReportController::balanceSheetReport
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
balanceSheetReport.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: balanceSheetReport.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ReportController::balanceSheetReport
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
    const balanceSheetReportForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: balanceSheetReport.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ReportController::balanceSheetReport
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
        balanceSheetReportForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: balanceSheetReport.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ReportController::balanceSheetReport
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
        balanceSheetReportForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: balanceSheetReport.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    balanceSheetReport.form = balanceSheetReportForm
const ReportController = { invoiceReport, balanceSheetReport }

export default ReportController