import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\CarrierController::create
 * @see app/Http/Controllers/CarrierController.php:26
 * @route '/carriers/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/carriers/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CarrierController::create
 * @see app/Http/Controllers/CarrierController.php:26
 * @route '/carriers/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\CarrierController::create
 * @see app/Http/Controllers/CarrierController.php:26
 * @route '/carriers/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\CarrierController::create
 * @see app/Http/Controllers/CarrierController.php:26
 * @route '/carriers/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\CarrierController::create
 * @see app/Http/Controllers/CarrierController.php:26
 * @route '/carriers/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\CarrierController::create
 * @see app/Http/Controllers/CarrierController.php:26
 * @route '/carriers/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\CarrierController::create
 * @see app/Http/Controllers/CarrierController.php:26
 * @route '/carriers/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\CarrierController::store
 * @see app/Http/Controllers/CarrierController.php:36
 * @route '/carriers'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/carriers',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\CarrierController::store
 * @see app/Http/Controllers/CarrierController.php:36
 * @route '/carriers'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\CarrierController::store
 * @see app/Http/Controllers/CarrierController.php:36
 * @route '/carriers'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\CarrierController::store
 * @see app/Http/Controllers/CarrierController.php:36
 * @route '/carriers'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\CarrierController::store
 * @see app/Http/Controllers/CarrierController.php:36
 * @route '/carriers'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\CarrierController::edit
 * @see app/Http/Controllers/CarrierController.php:67
 * @route '/carriers/{carrier}/edit'
 */
export const edit = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/carriers/{carrier}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CarrierController::edit
 * @see app/Http/Controllers/CarrierController.php:67
 * @route '/carriers/{carrier}/edit'
 */
edit.url = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { carrier: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    carrier: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        carrier: args.carrier,
                }

    return edit.definition.url
            .replace('{carrier}', parsedArgs.carrier.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CarrierController::edit
 * @see app/Http/Controllers/CarrierController.php:67
 * @route '/carriers/{carrier}/edit'
 */
edit.get = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\CarrierController::edit
 * @see app/Http/Controllers/CarrierController.php:67
 * @route '/carriers/{carrier}/edit'
 */
edit.head = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\CarrierController::edit
 * @see app/Http/Controllers/CarrierController.php:67
 * @route '/carriers/{carrier}/edit'
 */
    const editForm = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\CarrierController::edit
 * @see app/Http/Controllers/CarrierController.php:67
 * @route '/carriers/{carrier}/edit'
 */
        editForm.get = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\CarrierController::edit
 * @see app/Http/Controllers/CarrierController.php:67
 * @route '/carriers/{carrier}/edit'
 */
        editForm.head = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\CarrierController::update
 * @see app/Http/Controllers/CarrierController.php:80
 * @route '/carriers/{carrier}'
 */
export const update = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/carriers/{carrier}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\CarrierController::update
 * @see app/Http/Controllers/CarrierController.php:80
 * @route '/carriers/{carrier}'
 */
update.url = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { carrier: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    carrier: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        carrier: args.carrier,
                }

    return update.definition.url
            .replace('{carrier}', parsedArgs.carrier.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CarrierController::update
 * @see app/Http/Controllers/CarrierController.php:80
 * @route '/carriers/{carrier}'
 */
update.put = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\CarrierController::update
 * @see app/Http/Controllers/CarrierController.php:80
 * @route '/carriers/{carrier}'
 */
update.patch = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\CarrierController::update
 * @see app/Http/Controllers/CarrierController.php:80
 * @route '/carriers/{carrier}'
 */
    const updateForm = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\CarrierController::update
 * @see app/Http/Controllers/CarrierController.php:80
 * @route '/carriers/{carrier}'
 */
        updateForm.put = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\CarrierController::update
 * @see app/Http/Controllers/CarrierController.php:80
 * @route '/carriers/{carrier}'
 */
        updateForm.patch = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\CarrierController::destroy
 * @see app/Http/Controllers/CarrierController.php:102
 * @route '/carriers/{carrier}'
 */
export const destroy = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/carriers/{carrier}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\CarrierController::destroy
 * @see app/Http/Controllers/CarrierController.php:102
 * @route '/carriers/{carrier}'
 */
destroy.url = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { carrier: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    carrier: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        carrier: args.carrier,
                }

    return destroy.definition.url
            .replace('{carrier}', parsedArgs.carrier.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CarrierController::destroy
 * @see app/Http/Controllers/CarrierController.php:102
 * @route '/carriers/{carrier}'
 */
destroy.delete = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\CarrierController::destroy
 * @see app/Http/Controllers/CarrierController.php:102
 * @route '/carriers/{carrier}'
 */
    const destroyForm = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\CarrierController::destroy
 * @see app/Http/Controllers/CarrierController.php:102
 * @route '/carriers/{carrier}'
 */
        destroyForm.delete = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\CarrierController::index
 * @see app/Http/Controllers/CarrierController.php:16
 * @route '/carriers'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/carriers',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CarrierController::index
 * @see app/Http/Controllers/CarrierController.php:16
 * @route '/carriers'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\CarrierController::index
 * @see app/Http/Controllers/CarrierController.php:16
 * @route '/carriers'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\CarrierController::index
 * @see app/Http/Controllers/CarrierController.php:16
 * @route '/carriers'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\CarrierController::index
 * @see app/Http/Controllers/CarrierController.php:16
 * @route '/carriers'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\CarrierController::index
 * @see app/Http/Controllers/CarrierController.php:16
 * @route '/carriers'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\CarrierController::index
 * @see app/Http/Controllers/CarrierController.php:16
 * @route '/carriers'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\CarrierController::show
 * @see app/Http/Controllers/CarrierController.php:57
 * @route '/carriers/{carrier}'
 */
export const show = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/carriers/{carrier}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\CarrierController::show
 * @see app/Http/Controllers/CarrierController.php:57
 * @route '/carriers/{carrier}'
 */
show.url = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { carrier: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    carrier: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        carrier: args.carrier,
                }

    return show.definition.url
            .replace('{carrier}', parsedArgs.carrier.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\CarrierController::show
 * @see app/Http/Controllers/CarrierController.php:57
 * @route '/carriers/{carrier}'
 */
show.get = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\CarrierController::show
 * @see app/Http/Controllers/CarrierController.php:57
 * @route '/carriers/{carrier}'
 */
show.head = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\CarrierController::show
 * @see app/Http/Controllers/CarrierController.php:57
 * @route '/carriers/{carrier}'
 */
    const showForm = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\CarrierController::show
 * @see app/Http/Controllers/CarrierController.php:57
 * @route '/carriers/{carrier}'
 */
        showForm.get = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\CarrierController::show
 * @see app/Http/Controllers/CarrierController.php:57
 * @route '/carriers/{carrier}'
 */
        showForm.head = (args: { carrier: string | number } | [carrier: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
const carriers = {
    create: Object.assign(create, create),
store: Object.assign(store, store),
edit: Object.assign(edit, edit),
update: Object.assign(update, update),
destroy: Object.assign(destroy, destroy),
index: Object.assign(index, index),
show: Object.assign(show, show),
}

export default carriers