import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
export const invoice = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: invoice.url(args, options),
    method: 'get',
})

invoice.definition = {
    methods: ["get","head"],
    url: '/credit/clients/invoice/edit/{invoice_id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
invoice.url = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { invoice_id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    invoice_id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        invoice_id: args.invoice_id,
                }

    return invoice.definition.url
            .replace('{invoice_id}', parsedArgs.invoice_id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
invoice.get = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: invoice.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
invoice.head = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: invoice.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
    const invoiceForm = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: invoice.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
        invoiceForm.get = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: invoice.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:118
 * @route '/credit/clients/invoice/edit/{invoice_id}'
 */
        invoiceForm.head = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: invoice.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    invoice.form = invoiceForm
const creditClients = {
    invoice: Object.assign(invoice, invoice),
}

export default creditClients