import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\HotelBookingController::create
 * @see app/Http/Controllers/HotelBookingController.php:53
 * @route '/hotel-booking/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/hotel-booking/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelBookingController::create
 * @see app/Http/Controllers/HotelBookingController.php:53
 * @route '/hotel-booking/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelBookingController::create
 * @see app/Http/Controllers/HotelBookingController.php:53
 * @route '/hotel-booking/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelBookingController::create
 * @see app/Http/Controllers/HotelBookingController.php:53
 * @route '/hotel-booking/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelBookingController::create
 * @see app/Http/Controllers/HotelBookingController.php:53
 * @route '/hotel-booking/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelBookingController::create
 * @see app/Http/Controllers/HotelBookingController.php:53
 * @route '/hotel-booking/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelBookingController::create
 * @see app/Http/Controllers/HotelBookingController.php:53
 * @route '/hotel-booking/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\HotelBookingController::store
 * @see app/Http/Controllers/HotelBookingController.php:62
 * @route '/hotel-booking'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/hotel-booking',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\HotelBookingController::store
 * @see app/Http/Controllers/HotelBookingController.php:62
 * @route '/hotel-booking'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelBookingController::store
 * @see app/Http/Controllers/HotelBookingController.php:62
 * @route '/hotel-booking'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\HotelBookingController::store
 * @see app/Http/Controllers/HotelBookingController.php:62
 * @route '/hotel-booking'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HotelBookingController::store
 * @see app/Http/Controllers/HotelBookingController.php:62
 * @route '/hotel-booking'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\HotelBookingController::edit
 * @see app/Http/Controllers/HotelBookingController.php:101
 * @route '/hotel-booking/{hotel_booking}/edit'
 */
export const edit = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/hotel-booking/{hotel_booking}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelBookingController::edit
 * @see app/Http/Controllers/HotelBookingController.php:101
 * @route '/hotel-booking/{hotel_booking}/edit'
 */
edit.url = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel_booking: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel_booking: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel_booking: args.hotel_booking,
                }

    return edit.definition.url
            .replace('{hotel_booking}', parsedArgs.hotel_booking.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelBookingController::edit
 * @see app/Http/Controllers/HotelBookingController.php:101
 * @route '/hotel-booking/{hotel_booking}/edit'
 */
edit.get = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelBookingController::edit
 * @see app/Http/Controllers/HotelBookingController.php:101
 * @route '/hotel-booking/{hotel_booking}/edit'
 */
edit.head = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelBookingController::edit
 * @see app/Http/Controllers/HotelBookingController.php:101
 * @route '/hotel-booking/{hotel_booking}/edit'
 */
    const editForm = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelBookingController::edit
 * @see app/Http/Controllers/HotelBookingController.php:101
 * @route '/hotel-booking/{hotel_booking}/edit'
 */
        editForm.get = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelBookingController::edit
 * @see app/Http/Controllers/HotelBookingController.php:101
 * @route '/hotel-booking/{hotel_booking}/edit'
 */
        editForm.head = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\HotelBookingController::update
 * @see app/Http/Controllers/HotelBookingController.php:112
 * @route '/hotel-booking/{hotel_booking}'
 */
export const update = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/hotel-booking/{hotel_booking}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\HotelBookingController::update
 * @see app/Http/Controllers/HotelBookingController.php:112
 * @route '/hotel-booking/{hotel_booking}'
 */
update.url = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel_booking: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel_booking: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel_booking: args.hotel_booking,
                }

    return update.definition.url
            .replace('{hotel_booking}', parsedArgs.hotel_booking.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelBookingController::update
 * @see app/Http/Controllers/HotelBookingController.php:112
 * @route '/hotel-booking/{hotel_booking}'
 */
update.put = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\HotelBookingController::update
 * @see app/Http/Controllers/HotelBookingController.php:112
 * @route '/hotel-booking/{hotel_booking}'
 */
update.patch = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\HotelBookingController::update
 * @see app/Http/Controllers/HotelBookingController.php:112
 * @route '/hotel-booking/{hotel_booking}'
 */
    const updateForm = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HotelBookingController::update
 * @see app/Http/Controllers/HotelBookingController.php:112
 * @route '/hotel-booking/{hotel_booking}'
 */
        updateForm.put = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\HotelBookingController::update
 * @see app/Http/Controllers/HotelBookingController.php:112
 * @route '/hotel-booking/{hotel_booking}'
 */
        updateForm.patch = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\HotelBookingController::destroy
 * @see app/Http/Controllers/HotelBookingController.php:143
 * @route '/hotel-booking/{hotel_booking}'
 */
export const destroy = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/hotel-booking/{hotel_booking}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\HotelBookingController::destroy
 * @see app/Http/Controllers/HotelBookingController.php:143
 * @route '/hotel-booking/{hotel_booking}'
 */
destroy.url = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel_booking: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel_booking: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel_booking: args.hotel_booking,
                }

    return destroy.definition.url
            .replace('{hotel_booking}', parsedArgs.hotel_booking.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelBookingController::destroy
 * @see app/Http/Controllers/HotelBookingController.php:143
 * @route '/hotel-booking/{hotel_booking}'
 */
destroy.delete = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\HotelBookingController::destroy
 * @see app/Http/Controllers/HotelBookingController.php:143
 * @route '/hotel-booking/{hotel_booking}'
 */
    const destroyForm = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\HotelBookingController::destroy
 * @see app/Http/Controllers/HotelBookingController.php:143
 * @route '/hotel-booking/{hotel_booking}'
 */
        destroyForm.delete = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\HotelBookingController::index
 * @see app/Http/Controllers/HotelBookingController.php:15
 * @route '/hotel-booking'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/hotel-booking',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelBookingController::index
 * @see app/Http/Controllers/HotelBookingController.php:15
 * @route '/hotel-booking'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelBookingController::index
 * @see app/Http/Controllers/HotelBookingController.php:15
 * @route '/hotel-booking'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelBookingController::index
 * @see app/Http/Controllers/HotelBookingController.php:15
 * @route '/hotel-booking'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelBookingController::index
 * @see app/Http/Controllers/HotelBookingController.php:15
 * @route '/hotel-booking'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelBookingController::index
 * @see app/Http/Controllers/HotelBookingController.php:15
 * @route '/hotel-booking'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelBookingController::index
 * @see app/Http/Controllers/HotelBookingController.php:15
 * @route '/hotel-booking'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\HotelBookingController::show
 * @see app/Http/Controllers/HotelBookingController.php:92
 * @route '/hotel-booking/{hotel_booking}'
 */
export const show = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/hotel-booking/{hotel_booking}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\HotelBookingController::show
 * @see app/Http/Controllers/HotelBookingController.php:92
 * @route '/hotel-booking/{hotel_booking}'
 */
show.url = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { hotel_booking: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    hotel_booking: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        hotel_booking: args.hotel_booking,
                }

    return show.definition.url
            .replace('{hotel_booking}', parsedArgs.hotel_booking.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\HotelBookingController::show
 * @see app/Http/Controllers/HotelBookingController.php:92
 * @route '/hotel-booking/{hotel_booking}'
 */
show.get = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\HotelBookingController::show
 * @see app/Http/Controllers/HotelBookingController.php:92
 * @route '/hotel-booking/{hotel_booking}'
 */
show.head = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\HotelBookingController::show
 * @see app/Http/Controllers/HotelBookingController.php:92
 * @route '/hotel-booking/{hotel_booking}'
 */
    const showForm = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\HotelBookingController::show
 * @see app/Http/Controllers/HotelBookingController.php:92
 * @route '/hotel-booking/{hotel_booking}'
 */
        showForm.get = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\HotelBookingController::show
 * @see app/Http/Controllers/HotelBookingController.php:92
 * @route '/hotel-booking/{hotel_booking}'
 */
        showForm.head = (args: { hotel_booking: string | number } | [hotel_booking: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
const hotelBooking = {
    create: Object.assign(create, create),
store: Object.assign(store, store),
edit: Object.assign(edit, edit),
update: Object.assign(update, update),
destroy: Object.assign(destroy, destroy),
index: Object.assign(index, index),
show: Object.assign(show, show),
}

export default hotelBooking