import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\InvoiceController::print
 * @see app/Http/Controllers/InvoiceController.php:256
 * @route '/invoice/{id}/print'
 */
export const print = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: print.url(args, options),
    method: 'get',
})

print.definition = {
    methods: ["get","head"],
    url: '/invoice/{id}/print',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InvoiceController::print
 * @see app/Http/Controllers/InvoiceController.php:256
 * @route '/invoice/{id}/print'
 */
print.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        id: args.id,
                }

    return print.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\InvoiceController::print
 * @see app/Http/Controllers/InvoiceController.php:256
 * @route '/invoice/{id}/print'
 */
print.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: print.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\InvoiceController::print
 * @see app/Http/Controllers/InvoiceController.php:256
 * @route '/invoice/{id}/print'
 */
print.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: print.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\InvoiceController::print
 * @see app/Http/Controllers/InvoiceController.php:256
 * @route '/invoice/{id}/print'
 */
    const printForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: print.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\InvoiceController::print
 * @see app/Http/Controllers/InvoiceController.php:256
 * @route '/invoice/{id}/print'
 */
        printForm.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: print.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\InvoiceController::print
 * @see app/Http/Controllers/InvoiceController.php:256
 * @route '/invoice/{id}/print'
 */
        printForm.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: print.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    print.form = printForm
/**
* @see \App\Http\Controllers\InvoiceController::printList
 * @see app/Http/Controllers/InvoiceController.php:276
 * @route '/print/invoice'
 */
export const printList = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: printList.url(options),
    method: 'get',
})

printList.definition = {
    methods: ["get","head"],
    url: '/print/invoice',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\InvoiceController::printList
 * @see app/Http/Controllers/InvoiceController.php:276
 * @route '/print/invoice'
 */
printList.url = (options?: RouteQueryOptions) => {
    return printList.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InvoiceController::printList
 * @see app/Http/Controllers/InvoiceController.php:276
 * @route '/print/invoice'
 */
printList.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: printList.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\InvoiceController::printList
 * @see app/Http/Controllers/InvoiceController.php:276
 * @route '/print/invoice'
 */
printList.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: printList.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\InvoiceController::printList
 * @see app/Http/Controllers/InvoiceController.php:276
 * @route '/print/invoice'
 */
    const printListForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: printList.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\InvoiceController::printList
 * @see app/Http/Controllers/InvoiceController.php:276
 * @route '/print/invoice'
 */
        printListForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: printList.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\InvoiceController::printList
 * @see app/Http/Controllers/InvoiceController.php:276
 * @route '/print/invoice'
 */
        printListForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: printList.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    printList.form = printListForm
/**
* @see \App\Http\Controllers\InvoiceController::printMultiple
 * @see app/Http/Controllers/InvoiceController.php:286
 * @route '/invoice/print-multiple'
 */
export const printMultiple = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: printMultiple.url(options),
    method: 'post',
})

printMultiple.definition = {
    methods: ["post"],
    url: '/invoice/print-multiple',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\InvoiceController::printMultiple
 * @see app/Http/Controllers/InvoiceController.php:286
 * @route '/invoice/print-multiple'
 */
printMultiple.url = (options?: RouteQueryOptions) => {
    return printMultiple.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\InvoiceController::printMultiple
 * @see app/Http/Controllers/InvoiceController.php:286
 * @route '/invoice/print-multiple'
 */
printMultiple.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: printMultiple.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\InvoiceController::printMultiple
 * @see app/Http/Controllers/InvoiceController.php:286
 * @route '/invoice/print-multiple'
 */
    const printMultipleForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: printMultiple.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\InvoiceController::printMultiple
 * @see app/Http/Controllers/InvoiceController.php:286
 * @route '/invoice/print-multiple'
 */
        printMultipleForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: printMultiple.url(options),
            method: 'post',
        })
    
    printMultiple.form = printMultipleForm
const invoice = {
    print: Object.assign(print, print),
printList: Object.assign(printList, printList),
printMultiple: Object.assign(printMultiple, printMultiple),
}

export default invoice