import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\RefundController::create
 * @see app/Http/Controllers/RefundController.php:50
 * @route '/refunds/create'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/refunds/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\RefundController::create
 * @see app/Http/Controllers/RefundController.php:50
 * @route '/refunds/create'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\RefundController::create
 * @see app/Http/Controllers/RefundController.php:50
 * @route '/refunds/create'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\RefundController::create
 * @see app/Http/Controllers/RefundController.php:50
 * @route '/refunds/create'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\RefundController::create
 * @see app/Http/Controllers/RefundController.php:50
 * @route '/refunds/create'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\RefundController::create
 * @see app/Http/Controllers/RefundController.php:50
 * @route '/refunds/create'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\RefundController::create
 * @see app/Http/Controllers/RefundController.php:50
 * @route '/refunds/create'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\RefundController::store
 * @see app/Http/Controllers/RefundController.php:55
 * @route '/refunds'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/refunds',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\RefundController::store
 * @see app/Http/Controllers/RefundController.php:55
 * @route '/refunds'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\RefundController::store
 * @see app/Http/Controllers/RefundController.php:55
 * @route '/refunds'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\RefundController::store
 * @see app/Http/Controllers/RefundController.php:55
 * @route '/refunds'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\RefundController::store
 * @see app/Http/Controllers/RefundController.php:55
 * @route '/refunds'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\RefundController::edit
 * @see app/Http/Controllers/RefundController.php:90
 * @route '/refunds/{refund}/edit'
 */
export const edit = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/refunds/{refund}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\RefundController::edit
 * @see app/Http/Controllers/RefundController.php:90
 * @route '/refunds/{refund}/edit'
 */
edit.url = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { refund: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    refund: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        refund: args.refund,
                }

    return edit.definition.url
            .replace('{refund}', parsedArgs.refund.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\RefundController::edit
 * @see app/Http/Controllers/RefundController.php:90
 * @route '/refunds/{refund}/edit'
 */
edit.get = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\RefundController::edit
 * @see app/Http/Controllers/RefundController.php:90
 * @route '/refunds/{refund}/edit'
 */
edit.head = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\RefundController::edit
 * @see app/Http/Controllers/RefundController.php:90
 * @route '/refunds/{refund}/edit'
 */
    const editForm = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: edit.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\RefundController::edit
 * @see app/Http/Controllers/RefundController.php:90
 * @route '/refunds/{refund}/edit'
 */
        editForm.get = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\RefundController::edit
 * @see app/Http/Controllers/RefundController.php:90
 * @route '/refunds/{refund}/edit'
 */
        editForm.head = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: edit.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    edit.form = editForm
/**
* @see \App\Http\Controllers\RefundController::update
 * @see app/Http/Controllers/RefundController.php:99
 * @route '/refunds/{refund}'
 */
export const update = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put","patch"],
    url: '/refunds/{refund}',
} satisfies RouteDefinition<["put","patch"]>

/**
* @see \App\Http\Controllers\RefundController::update
 * @see app/Http/Controllers/RefundController.php:99
 * @route '/refunds/{refund}'
 */
update.url = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { refund: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    refund: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        refund: args.refund,
                }

    return update.definition.url
            .replace('{refund}', parsedArgs.refund.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\RefundController::update
 * @see app/Http/Controllers/RefundController.php:99
 * @route '/refunds/{refund}'
 */
update.put = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})
/**
* @see \App\Http\Controllers\RefundController::update
 * @see app/Http/Controllers/RefundController.php:99
 * @route '/refunds/{refund}'
 */
update.patch = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'patch'> => ({
    url: update.url(args, options),
    method: 'patch',
})

    /**
* @see \App\Http\Controllers\RefundController::update
 * @see app/Http/Controllers/RefundController.php:99
 * @route '/refunds/{refund}'
 */
    const updateForm = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: update.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\RefundController::update
 * @see app/Http/Controllers/RefundController.php:99
 * @route '/refunds/{refund}'
 */
        updateForm.put = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
            /**
* @see \App\Http\Controllers\RefundController::update
 * @see app/Http/Controllers/RefundController.php:99
 * @route '/refunds/{refund}'
 */
        updateForm.patch = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: update.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PATCH',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    update.form = updateForm
/**
* @see \App\Http\Controllers\RefundController::destroy
 * @see app/Http/Controllers/RefundController.php:170
 * @route '/refunds/{refund}'
 */
export const destroy = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/refunds/{refund}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\RefundController::destroy
 * @see app/Http/Controllers/RefundController.php:170
 * @route '/refunds/{refund}'
 */
destroy.url = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { refund: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    refund: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        refund: args.refund,
                }

    return destroy.definition.url
            .replace('{refund}', parsedArgs.refund.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\RefundController::destroy
 * @see app/Http/Controllers/RefundController.php:170
 * @route '/refunds/{refund}'
 */
destroy.delete = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

    /**
* @see \App\Http\Controllers\RefundController::destroy
 * @see app/Http/Controllers/RefundController.php:170
 * @route '/refunds/{refund}'
 */
    const destroyForm = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: destroy.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'DELETE',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\RefundController::destroy
 * @see app/Http/Controllers/RefundController.php:170
 * @route '/refunds/{refund}'
 */
        destroyForm.delete = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: destroy.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'DELETE',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    destroy.form = destroyForm
/**
* @see \App\Http\Controllers\RefundController::index
 * @see app/Http/Controllers/RefundController.php:19
 * @route '/refunds'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/refunds',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\RefundController::index
 * @see app/Http/Controllers/RefundController.php:19
 * @route '/refunds'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\RefundController::index
 * @see app/Http/Controllers/RefundController.php:19
 * @route '/refunds'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\RefundController::index
 * @see app/Http/Controllers/RefundController.php:19
 * @route '/refunds'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\RefundController::index
 * @see app/Http/Controllers/RefundController.php:19
 * @route '/refunds'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\RefundController::index
 * @see app/Http/Controllers/RefundController.php:19
 * @route '/refunds'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\RefundController::index
 * @see app/Http/Controllers/RefundController.php:19
 * @route '/refunds'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
/**
* @see \App\Http\Controllers\RefundController::show
 * @see app/Http/Controllers/RefundController.php:81
 * @route '/refunds/{refund}'
 */
export const show = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/refunds/{refund}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\RefundController::show
 * @see app/Http/Controllers/RefundController.php:81
 * @route '/refunds/{refund}'
 */
show.url = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { refund: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    refund: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        refund: args.refund,
                }

    return show.definition.url
            .replace('{refund}', parsedArgs.refund.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\RefundController::show
 * @see app/Http/Controllers/RefundController.php:81
 * @route '/refunds/{refund}'
 */
show.get = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\RefundController::show
 * @see app/Http/Controllers/RefundController.php:81
 * @route '/refunds/{refund}'
 */
show.head = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\RefundController::show
 * @see app/Http/Controllers/RefundController.php:81
 * @route '/refunds/{refund}'
 */
    const showForm = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: show.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\RefundController::show
 * @see app/Http/Controllers/RefundController.php:81
 * @route '/refunds/{refund}'
 */
        showForm.get = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\RefundController::show
 * @see app/Http/Controllers/RefundController.php:81
 * @route '/refunds/{refund}'
 */
        showForm.head = (args: { refund: string | number } | [refund: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: show.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    show.form = showForm
const refunds = {
    create: Object.assign(create, create),
store: Object.assign(store, store),
edit: Object.assign(edit, edit),
update: Object.assign(update, update),
destroy: Object.assign(destroy, destroy),
index: Object.assign(index, index),
show: Object.assign(show, show),
}

export default refunds