import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
/**
* @see \App\Http\Controllers\ReportController::invoices
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
export const invoices = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: invoices.url(options),
    method: 'get',
})

invoices.definition = {
    methods: ["get","head"],
    url: '/reports/invoices',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ReportController::invoices
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
invoices.url = (options?: RouteQueryOptions) => {
    return invoices.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ReportController::invoices
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
invoices.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: invoices.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ReportController::invoices
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
invoices.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: invoices.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ReportController::invoices
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
    const invoicesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: invoices.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ReportController::invoices
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
        invoicesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: invoices.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ReportController::invoices
 * @see app/Http/Controllers/ReportController.php:16
 * @route '/reports/invoices'
 */
        invoicesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: invoices.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    invoices.form = invoicesForm
/**
* @see \App\Http\Controllers\ReportController::balanceSheet
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
export const balanceSheet = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: balanceSheet.url(options),
    method: 'get',
})

balanceSheet.definition = {
    methods: ["get","head"],
    url: '/reports/balance-sheet',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ReportController::balanceSheet
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
balanceSheet.url = (options?: RouteQueryOptions) => {
    return balanceSheet.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ReportController::balanceSheet
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
balanceSheet.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: balanceSheet.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\ReportController::balanceSheet
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
balanceSheet.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: balanceSheet.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\ReportController::balanceSheet
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
    const balanceSheetForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: balanceSheet.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\ReportController::balanceSheet
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
        balanceSheetForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: balanceSheet.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\ReportController::balanceSheet
 * @see app/Http/Controllers/ReportController.php:64
 * @route '/reports/balance-sheet'
 */
        balanceSheetForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: balanceSheet.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    balanceSheet.form = balanceSheetForm
const reports = {
    invoices: Object.assign(invoices, invoices),
balanceSheet: Object.assign(balanceSheet, balanceSheet),
}

export default reports