import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
export const invoice = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: invoice.url(args, options),
    method: 'put',
})

invoice.definition = {
    methods: ["put"],
    url: '/credit/clients/invoice/update/{invoice_id}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
invoice.url = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { invoice_id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    invoice_id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        invoice_id: args.invoice_id,
                }

    return invoice.definition.url
            .replace('{invoice_id}', parsedArgs.invoice_id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
invoice.put = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: invoice.url(args, options),
    method: 'put',
})

    /**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
    const invoiceForm = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: invoice.url(args, {
                    [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                        _method: 'PUT',
                        ...(options?.query ?? options?.mergeQuery ?? {}),
                    }
                }),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\ClientController::invoice
 * @see app/Http/Controllers/ClientController.php:127
 * @route '/credit/clients/invoice/update/{invoice_id}'
 */
        invoiceForm.put = (args: { invoice_id: string | number } | [invoice_id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: invoice.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'PUT',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'post',
        })
    
    invoice.form = invoiceForm
const creditClients = {
    invoice: Object.assign(invoice, invoice),
}

export default creditClients