<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Travel Invoice</title>
    <style>
        .ta-invoice{
            width: 210mm;
            height: 297mm;
            margin: 0  auto;
            font-family: "Calibri",Sans-serif;
            padding: 40px 80px;
            -webkit-box-shadow: 1px 5px 5px #d0dae7;
            -moz-box-shadow: 1px 5px 5px #d0dae7;
            box-shadow: 1px 5px 5px #d0dae7;
        }

        .ta-invoice-inner{
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-direction: column;
            height: 100%;
        }
        .ta-invoice-head{
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .invoice-title{
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .company-name{
            font-size: 14px;
            margin-left: 20px;
        }

        .ta-invoice-end{
            width: 25%;
        }
        .logo-image{
            display: flex;
            justify-content: end;
            margin-bottom: 40px;
        }

        .logo-image img{
            height: 110px;
            width: auto;
            -o-object-fit: cover;
            object-fit: cover;
        }

        .single-details{
            margin-bottom: 16px;
            font-size: 14px;
        }
        .text-title{
            font-size: 14px;
            font-weight: 700;
        }
        .invoice-table{
            margin-top: 40px;
        }

        .invoice-table table{
            width: 100%;
            text-align: left;
            border-collapse: collapse;
        }

        .description{
            width: 40%;
        }
        
        .text-end{
            text-align: right;
        }

        .invoice-table tr th{
            border-bottom: 3px solid #0a0a0a;
            font-weight: 700;
            font-size: 16px;
            padding: 5px 0;
        }

        .invoice-table tr td{
            font-size: 16px;
            border-bottom: 3px solid #c5c6c7;
            padding: 5px 0;
        }
        
        .item-info{
            font-size: 14px;
            line-height: 1.4;
        }
        .item-info .value{
            margin-left: 5px;
        }

        .subtotal-table{
            width: 60%;
            margin-left: auto;
        }

        .subtotal-table table{
            width: 100%;
            border-collapse: collapse;
        }
        
        .subtotal-table table td{
            text-align: right;
            width: 50%;
            border-bottom: 2px solid #050505;
            padding: 5px 0;

        }

        .subtotal-table table tr:last-child td{
            border-bottom: 0;
        }

        .text-bold{
            font-weight: 700;
        }
        .bb-none td{
            border-bottom: none !important;
        }

        .invoice-data{
            width: 100%;
        }

        .invoice-footer{
            width: 100%;
        }

        .check-and-confirm{
            font-weight: 700;
            font-size: 16px;
        }
        
        .company-info{
            text-align: right;
            margin-top: 30px;
            line-height: 1.4;
        }

        .comp-name{
            font-weight: 700;
            line-height: 1.4;
        }
        
        .comp-address{
            font-size: 14px;
            line-height: 1.4;
        }

        .comp-contact{
           font-size: 14px;
            line-height: 1.4;
        }
        
        @media print {
            .ta-invoice{
                -webkit-box-shadow: none;
                -moz-box-shadow: none;
                box-shadow: none;
                padding-bottom: 0;
                margin-bottom: 0;
            }

        }

        @page {
            size: A4 portrait;
        }


    </style>

</head>
<body>

@php
    $firstInvoice = $invoices->first();
    $total = $invoices->sum(fn($inv) => $inv->payment->total_amount ?? 0);
    $paid = $invoices->sum(fn($inv) => $inv->payment->paid_amount ?? 0);
    $due = $invoices->sum(fn($inv) => $inv->payment->due_amount ?? 0);
@endphp

<div class="ta-invoice">
    <div class="ta-invoice-inner">

        {{-- ===== HEADER ===== --}}
        <div class="ta-invoice-head">
            <div class="ta-invoice-start">
                <div class="invoice-title">INVOICE</div>
                <div class="company-name">Victory Travel Pte Ltd</div>
            </div>

            <div class="ta-invoice-end">
                <div class="logo-image">
                    <img src="{{ public_path('ta-logo.png') }}" alt="Company Logo">
                </div>
            </div>
        </div>

        {{-- ===== INVOICE META ===== --}}
        <div class="invoice-meta" style="text-align: right; margin-bottom: 15px;">
            <div class="single-details">
                <span class="text-title">Invoice Date:</span>
                <span>{{ date('d M Y', strtotime($firstInvoice->invoice_date)) }}</span>
            </div>
            <div class="single-details">
                <span class="text-title">Invoice No:</span>
                <span>{{ $firstInvoice->ticket_no }}</span>
            </div>
            <div class="single-details">
                <span class="text-title">Reference:</span>
                <span>{{ $firstInvoice->carrier->name ?? 'N/A' }}</span>
            </div>
        </div>

        {{-- ===== TABLE ===== --}}
        <div class="invoice-table">
            <table>
                <thead>
                    <tr>
                        <th class="description">Description</th>
                        <th class="text-end">Quantity</th>
                        <th class="text-end">Unit Price</th>
                        <th class="text-end">Amount SGD</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($invoices as $invoice)
                        <tr>
                            <td>
                                <div class="item-info">Ticket Type: {{ $invoice->ticket_type ?? 'Economy' }}</div>
                                <div class="item-info">PNR: {{ $invoice->pnr ?? 'N/A' }}</div>
                                <div class="item-info">Flight Date: {{ date('d M Y', strtotime($invoice->flight_date)) }}</div>
                            </td>
                            <td class="text-end">1</td>
                            <td class="text-end">{{ number_format($invoice->sales_amount, 2) }}</td>
                            <td class="text-end">{{ number_format($invoice->payment->total_amount ?? 0, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        {{-- ===== TOTALS ===== --}}
        <div class="subtotal-table">
            <table>
                <tr>
                    <td>Invoice Total</td>
                    <td>{{ number_format($total, 2) }}</td>
                </tr>
                <tr>
                    <td>Total Paid</td>
                    <td>{{ number_format($paid, 2) }}</td>
                </tr>
                <tr>
                    <td class="text-bold">Amount Due</td>
                    <td class="text-bold">{{ number_format($due, 2) }}</td>
                </tr>
            </table>
        </div>

        {{-- ===== FOOTER ===== --}}
        <div class="invoice-footer">
            <div class="check-and-confirm">
                Please make all cheques payable to: <strong>JA Travel Pte Ltd</strong><br>
                Bank Info: DBS : 010-011-413-6 | PayNow: UEN 199502345D | Mobile: 9756 0887
            </div>

            <div class="company-info">
                <div class="comp-name">JA Travel Pte Ltd</div>
                <div>100 Jalan Sultan, #04-10 Sultan Plaza Singapore 199001</div>
                <div>
                    Tel: +65-6534-4740 | HP: +65-9756-0887<br>
                    Email: <a href="mailto:info@ja-travel.com">info@ja-travel.com</a><br>
                    Website: <a href="https://www.jatravel.com.sg">www.jatravel.com.sg</a> | TA 00945 | Reg No: 199502345D
                </div>
            </div>
        </div>

    </div>
</div>

</body>
</html>
