<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Invoice #{{ $invoice->id }}</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; color: #333; }
        .invoice-box { max-width: 800px; margin: auto; padding: 20px; border: 1px solid #eee; }
        h1 { text-align: center; font-size: 24px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        table th, table td { border: 1px solid #ddd; padding: 8px; }
        table th { background-color: #f2f2f2; }
        .text-right { text-align: right; }
        .total { font-weight: bold; }
    </style>
</head>
<body>
    <div class="invoice-box">
        <h1>Invoice</h1>

        <p><strong>Invoice ID:</strong> {{ $invoice->id }}</p>
        <p><strong>Date:</strong> {{ $invoice->invoice_date->format('Y-m-d') }}</p>
        <p><strong>Client:</strong> {{ $invoice->client->name }}</p>
        <p><strong>Company:</strong> {{ $invoice->company->name }}</p>

        {{-- <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Description</th>
                    <th class="text-right">Quantity</th>
                    <th class="text-right">Unit Price</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $index => $item)s
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item->pnr }}</td>
                    <td class="text-right"> 1 </td>
                    <td class="text-right">{{ number_format($item->unit_price, 2) }}</td>
                    <td class="text-right">{{ number_format($item->quantity * $item->unit_price, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <table>
            <tr>
                <td class="text-right total" colspan="4">Subtotal</td>
                <td class="text-right total">{{ number_format($invoice->subtotal, 2) }}</td>
            </tr>
            <tr>
                <td class="text-right total" colspan="4">Tax ({{ $invoice->tax_percentage }}%)</td>
                <td class="text-right total">{{ number_format($invoice->tax_amount, 2) }}</td>
            </tr>
            <tr>
                <td class="text-right total" colspan="4">Grand Total</td>
                <td class="text-right total">{{ number_format($invoice->grand_total, 2) }}</td>
            </tr>
        </table> --}}

        <p style="margin-top: 30px;">Thank you for your business!</p>
    </div>
</body>
</html>
