<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\CarrierController;
use App\Http\Controllers\HotelController;
use App\Http\Controllers\PaymentTermsController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\HotelBookingController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\IncomeController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\FundTransferController;
use App\Http\Controllers\RefundController;

Route::get('/', function () {
    return Inertia::render('Welcome');
})->name('home');

Route::get('dashboard', function () {
    return Inertia::render('Dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

// Route::resource('users', UserController::class);
Route::resource('users', UserController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('users', UserController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('users', UserController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('users', UserController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('roles', RoleController::class);

Route::get('/companies', [CompanyController::class, 'index'])->name('companies.index');
Route::get('/companies/create', [CompanyController::class, 'create'])->name('companies.create'); 
Route::post('/companies', [CompanyController::class, 'store'])->name('companies.store'); 
Route::get('/companies/{company}', [CompanyController::class, 'show'])->name('companies.show'); 
Route::get('/companies/{company}/edit', [CompanyController::class, 'edit'])->name('companies.edit'); 
Route::put('/companies/{company}', [CompanyController::class, 'update'])->name('companies.update'); 
Route::delete('/companies/{company}', [CompanyController::class, 'destroy'])->name('companies.delete'); 

Route::resource('clients', ClientController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('clients', ClientController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('clients', ClientController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('clients', ClientController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::get('/credit/clients', [ClientController::class, 'creditClients'])->name('clients.credit-clients');
Route::get('/credit/clients/invoice/edit/{invoice_id}', [ClientController::class, 'editCreditClientsInvoice'])->name('edit.credit-clients.invoice');
Route::put('/credit/clients/invoice/update/{invoice_id}', [ClientController::class, 'updateCreditClientsInvoice'])->name('update.credit-clients.invoice');

Route::resource('carriers', CarrierController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('carriers', CarrierController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('carriers', CarrierController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('carriers', CarrierController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('hotels', HotelController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('hotels', HotelController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('hotels', HotelController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('hotels', HotelController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('payment-terms', PaymentTermsController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('payment-terms', PaymentTermsController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('payment-terms', PaymentTermsController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('payment-terms', PaymentTermsController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('countries', CountryController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('countries', CountryController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('countries', CountryController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('countries', CountryController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('vendors', VendorController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('vendors', VendorController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('vendors', VendorController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('vendors', VendorController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('purchase-orders', PurchaseOrderController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('purchase-orders', PurchaseOrderController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('purchase-orders', PurchaseOrderController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('purchase-orders', PurchaseOrderController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('hotel-booking', HotelBookingController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('hotel-booking', HotelBookingController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('hotel-booking', HotelBookingController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('hotel-booking', HotelBookingController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('invoices', InvoiceController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('invoices', InvoiceController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('invoices', InvoiceController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('invoices', InvoiceController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::get('/invoice/{id}/print', [InvoiceController::class, 'print'])->name('invoice.print');
Route::get('/print/invoice', [InvoiceController::class, 'printList'])->name('invoice.printList');
Route::post('/invoice/print-multiple', [InvoiceController::class, 'printMultiple'])->name('invoice.printMultiple');

Route::resource('incomes', IncomeController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('incomes', IncomeController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('incomes', IncomeController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('incomes', IncomeController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('expenses', ExpenseController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('expenses', ExpenseController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('expenses', ExpenseController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('expenses', ExpenseController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('bank-accounts', BankAccountController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('bank-accounts', BankAccountController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('bank-accounts', BankAccountController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('bank-accounts', BankAccountController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('fund-transfers', FundTransferController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('fund-transfers', FundTransferController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('fund-transfers', FundTransferController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('fund-transfers', FundTransferController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::resource('refunds', RefundController::class)->only(['create', 'store'])->middleware('permission:users.create');
Route::resource('refunds', RefundController::class)->only(['edit', 'update'])->middleware('permission:users.edit');
Route::resource('refunds', RefundController::class)->only(['destroy'])->middleware('permission:users.destroy');
Route::resource('refunds', RefundController::class)->only(['index', 'show'])->middleware('permission:users.destroy|users.create|users.edit|users.view');

Route::get('/refunds/{id}/print', [RefundController::class, 'print'])->name('refund.invoice.print');

Route::get('/reports/invoices', [ReportController::class, 'invoiceReport'])->name('reports.invoices');
Route::get('/reports/balance-sheet', [ReportController::class, 'balanceSheetReport'])->name('reports.balance-sheet');


require __DIR__.'/settings.php';
require __DIR__.'/auth.php';



