<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Travel Invoice</title>
    <style>
        body {
            font-family: "Calibri", sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 0;
            padding-right: 10px;
            color: #000;
        }

        .ta-invoice {
            width: 180mm;
            margin: 0 0 0 20px;
            padding: 40px 60px;
            box-sizing: border-box;
        }

        .ta-invoice-inner {
            display: flex;
            flex-direction: column;
        }

        /* ===== LOGO SECTION ===== */
        .logo-section {
            text-align: right;
            margin-bottom: 20px;
        }

        .logo-image img {
            height: 80px; /* Slightly smaller to fit better */
            width: auto;
            object-fit: contain;
        }

        /* ===== HEADER ===== */
        .ta-invoice-head {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
        }

        .ta-invoice-start {
            flex: 1;
        }

        .invoice-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 6px;
        }

        .company-name {
            font-size: 16px;
            font-weight: 600;
        }

        .ta-invoice-end {
            text-align: right;
        }

        .invoice-meta {
            margin-top: 15px;
        }

        .single-details {
            margin-bottom: 6px;
            font-size: 14px;
        }

        .text-title {
            font-weight: 700;
        }

        /* ===== TABLE ===== */
        .invoice-table {
            margin-top: 20px;
        }

        .invoice-table table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
        }

        .description {
            width: 40%;
        }

        .text-end {
            text-align: right;
        }

        .invoice-table th {
            border-bottom: 2px solid #000;
            font-weight: 700;
            padding: 6px 0;
        }

        .invoice-table td {
            border-bottom: 1px solid #999;
            padding: 5px 0;
        }

        .item-info {
            font-size: 14px;
            line-height: 1.4;
        }

        /* ===== TOTALS ===== */
        .subtotal-table {
            width: 60%;
            margin-left: auto;
            margin-top: 25px;
        }

        .subtotal-table table {
            width: 100%;
            border-collapse: collapse;
        }

        .subtotal-table td {
            text-align: right;
            width: 50%;
            border-bottom: 1px solid #000;
            padding: 6px 0;
        }

        .text-bold {
            font-weight: 700;
        }

        /* ===== FOOTER ===== */
        /* .invoice-footer {
            margin-top: 40px;
        } */
        .invoice-footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            width: 100%;
            padding: 20px 60px;
            box-sizing: border-box;
            margin: 0;
            background: #fff; /* Optional: ensures no overlap artifacts */
        }

        .check-and-confirm {
            font-weight: 700;
            font-size: 14px;
            margin-bottom: 60px;
        }

        .company-info {
            text-align: right;
            font-size: 13px;
            line-height: 1.5;
            margin-right: 30mm;
        }

        .comp-name {
            font-weight: 700;
        }

        @page {
            size: A4 portrait;
            margin: -5mm;
        }
    </style>
</head>
<body>

<?php
    $firstInvoice = $invoices->first();
    $total = $invoices->sum(fn($inv) => $inv->payment->total_amount ?? 0);
    $paid = $invoices->sum(fn($inv) => $inv->payment->paid_amount ?? 0);
    $due = $invoices->sum(fn($inv) => $inv->payment->due_amount ?? 0);
?>

<div class="ta-invoice">
    <div class="ta-invoice-inner">

        
        <div class="logo-section">
            <div class="logo-image">
                <img src="<?php echo e(public_path('ta-logo.png')); ?>" alt="Company Logo">
            </div>
        </div>

        
        <div class="ta-invoice-head">
            <div class="ta-invoice-start">
                <div class="invoice-title">INVOICE</div>
                <div class="company-name">Victory Travel Pte Ltd</div>
            </div>

            <div class="ta-invoice-end">
                
            </div>
        </div>

        
        <div class="invoice-meta" style="text-align: right; margin-bottom: 15px;">
            <div class="single-details">
                <span class="text-title">Invoice Date:</span>
                <span><?php echo e(date('d M Y', strtotime($firstInvoice->invoice_date))); ?></span>
            </div>
            <div class="single-details">
                <span class="text-title">Invoice No:</span>
                <span><?php echo e($firstInvoice->ticket_no); ?></span>
            </div>
            <div class="single-details">
                <span class="text-title">Reference:</span>
                <span><?php echo e($firstInvoice->carrier->name ?? 'N/A'); ?></span>
            </div>
        </div>

        
        <div class="invoice-table">
            <table>
                <thead>
                    <tr>
                        <th class="description">Description</th>
                        <th class="text-end">Quantity</th>
                        <th class="text-end">Unit Price</th>
                        <th class="text-end">Amount SGD</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <div class="item-info">Ticket Type: <?php echo e($invoice->ticket_type ?? 'Economy'); ?></div>
                                <div class="item-info">PNR: <?php echo e($invoice->pnr ?? 'N/A'); ?></div>
                                <div class="item-info">Flight Date: <?php echo e(date('d M Y', strtotime($invoice->flight_date))); ?></div>
                            </td>
                            <td class="text-end">1</td>
                            <td class="text-end"><?php echo e(number_format($invoice->sales_amount, 2)); ?></td>
                            <td class="text-end"><?php echo e(number_format($invoice->payment->total_amount ?? 0, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        
        <div class="subtotal-table">
            <table>
                <tr>
                    <td>Invoice Total</td>
                    <td><?php echo e(number_format($total, 2)); ?></td>
                </tr>
                <tr>
                    <td>Total Paid</td>
                    <td><?php echo e(number_format($paid, 2)); ?></td>
                </tr>
                <tr>
                    <td class="text-bold">Amount Due</td>
                    <td class="text-bold"><?php echo e(number_format($due, 2)); ?></td>
                </tr>
            </table>
        </div>

        
        <div class="invoice-footer">
            <div class="check-and-confirm">
                Please make all cheques payable to: <strong>JA Travel Pte Ltd</strong><br>
                Bank Info: DBS : 010-011-413-6 | PayNow: UEN 199502345D | Mobile: 9756 0887
            </div>

            <div class="company-info">
                <div class="comp-name">JA Travel Pte Ltd</div>
                <div>100 Jalan Sultan, #04-10 Sultan Plaza Singapore 199001</div>
                <div>
                    Tel: +65-6534-4740 | HP: +65-9756-0887<br>
                    Email: <a href="mailto:info@ja-travel.com">info@ja-travel.com</a><br>
                    Website: <a href="https://www.jatravel.com.sg">www.jatravel.com.sg</a> | TA 00945 | Reg No: 199502345D
                </div>
            </div>
        </div>

    </div>
</div>

</body>
</html><?php /**PATH C:\xampp\htdocs\travel_accounting\resources\views/invoices/pdf-multiple.blade.php ENDPATH**/ ?>